/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.settle;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.service.SettleService;
import org.apache.iotdb.db.storageengine.dataregion.compaction.settle.SettleLog;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.tools.settle.TsFileAndModSettleTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettleTask
extends WrappedRunnable {
    private static final Logger logger = LoggerFactory.getLogger(SettleTask.class);
    private final TsFileResource resourceToBeSettled;

    public SettleTask(TsFileResource resourceToBeSettled) {
        this.resourceToBeSettled = resourceToBeSettled;
    }

    public void runMayThrow() {
        try {
            this.settleTsFile();
        }
        catch (Exception e) {
            logger.error("meet error when settling file:{}", (Object)this.resourceToBeSettled.getTsFile().getAbsolutePath(), (Object)e);
        }
    }

    public void settleTsFile() throws WriteProcessException {
        ArrayList<TsFileResource> settledResources = new ArrayList();
        if (!this.resourceToBeSettled.isClosed()) {
            logger.warn("The tsFile {} should be sealed when settling.", (Object)this.resourceToBeSettled.getTsFile().getAbsolutePath());
            return;
        }
        TsFileAndModSettleTool tsFileAndModSettleTool = TsFileAndModSettleTool.getInstance();
        try {
            if (tsFileAndModSettleTool.isSettledFileGenerated(this.resourceToBeSettled)) {
                logger.info("find settled file for {}", (Object)this.resourceToBeSettled.getTsFile());
                settledResources = tsFileAndModSettleTool.findSettledFile(this.resourceToBeSettled);
            } else {
                logger.info("generate settled file for {}", (Object)this.resourceToBeSettled.getTsFile());
                SettleLog.writeSettleLog(this.resourceToBeSettled.getTsFile().getAbsolutePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.BEGIN_SETTLE_FILE));
                tsFileAndModSettleTool.settleOneTsFileAndMod(this.resourceToBeSettled, settledResources);
                SettleLog.writeSettleLog(this.resourceToBeSettled.getTsFile().getAbsolutePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.AFTER_SETTLE_FILE));
            }
        }
        catch (IOException | IllegalPathException | org.apache.iotdb.tsfile.exception.write.WriteProcessException e) {
            this.resourceToBeSettled.readUnlock();
            throw new WriteProcessException(String.format("Exception to parse the tsfile: %s in settling", this.resourceToBeSettled.getTsFile().getAbsolutePath()), e);
        }
        this.resourceToBeSettled.getSettleTsFileCallBack().call(this.resourceToBeSettled, settledResources);
        SettleLog.writeSettleLog(this.resourceToBeSettled.getTsFile().getAbsolutePath() + "," + (Object)((Object)SettleLog.SettleCheckStatus.SETTLE_SUCCESS));
        logger.info("Settle completes, file path:{} , the remaining file to be settled num: {}", (Object)this.resourceToBeSettled.getTsFile().getAbsolutePath(), (Object)SettleService.getINSTANCE().getFilesToBeSettledCount().get());
        if (SettleService.getINSTANCE().getFilesToBeSettledCount().get() == 0) {
            SettleLog.closeLogWriter();
            SettleService.getINSTANCE().stop();
            logger.info("All files settled successfully! ");
        }
    }
}

