/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FileInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;

public class CompactionEstimateUtils {
    public static FileInfo calculateFileInfo(TsFileSequenceReader reader) throws IOException {
        int totalChunkNum = 0;
        int maxChunkNum = 0;
        int maxAlignedSeriesNumInDevice = -1;
        int maxDeviceChunkNum = 0;
        Map deviceMetadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : deviceMetadata.entrySet()) {
            int deviceChunkNum = 0;
            List deviceTimeseriesMetadata = (List)entry.getValue();
            if (((TimeseriesMetadata)deviceTimeseriesMetadata.get(0)).getMeasurementId().equals("")) {
                maxAlignedSeriesNumInDevice = Math.max(maxAlignedSeriesNumInDevice, deviceTimeseriesMetadata.size());
            }
            for (TimeseriesMetadata timeseriesMetadata : deviceTimeseriesMetadata) {
                deviceChunkNum += timeseriesMetadata.getChunkMetadataList().size();
                totalChunkNum += timeseriesMetadata.getChunkMetadataList().size();
                maxChunkNum = Math.max(maxChunkNum, timeseriesMetadata.getChunkMetadataList().size());
            }
            maxDeviceChunkNum = Math.max(maxDeviceChunkNum, deviceChunkNum);
        }
        long averageChunkMetadataSize = totalChunkNum == 0 ? 0L : reader.getAllMetadataSize() / (long)totalChunkNum;
        return new FileInfo(totalChunkNum, maxChunkNum, maxAlignedSeriesNumInDevice, maxDeviceChunkNum, averageChunkMetadataSize);
    }

    public static boolean addReadLock(List<TsFileResource> resources) {
        for (int i = 0; i < resources.size(); ++i) {
            TsFileResource resource = resources.get(i);
            resource.readLock();
            if (!resource.isDeleted()) continue;
            for (int j = 0; j <= i; ++j) {
                resources.get(j).readUnlock();
            }
            return false;
        }
        return true;
    }

    public static void releaseReadLock(List<TsFileResource> resources) {
        resources.forEach(TsFileResource::readUnlock);
    }
}

