/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionTaskStage;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class CompactionLogger
implements AutoCloseable {
    public static final String CROSS_COMPACTION_LOG_NAME_SUFFIX = ".cross-compaction.log";
    public static final String INNER_COMPACTION_LOG_NAME_SUFFIX = ".inner-compaction.log";
    public static final String INSERTION_COMPACTION_LOG_NAME_SUFFIX = ".insertion-compaction.log";
    public static final String STR_SOURCE_FILES = "source";
    public static final String STR_TARGET_FILES = "target";
    public static final String STR_DELETED_TARGET_FILES = "empty";
    private FileOutputStream logStream;

    public CompactionLogger(File logFile) throws IOException {
        this.logStream = new FileOutputStream(logFile, true);
    }

    @Override
    public void close() throws IOException {
        this.logStream.close();
    }

    public void logFiles(List<TsFileResource> tsFiles, String flag) throws IOException {
        for (TsFileResource tsFileResource : tsFiles) {
            this.logFile(tsFileResource, flag);
        }
    }

    public void logTaskStage(CompactionTaskStage stage) throws IOException {
        this.logStream.write(stage.name().getBytes());
        this.logStream.write(System.lineSeparator().getBytes());
        this.logStream.flush();
    }

    public void logFile(TsFileResource tsFile, String flag) throws IOException {
        String log = flag + " " + TsFileIdentifier.getFileIdentifierFromFilePath(tsFile.getTsFile().getAbsolutePath());
        this.logStream.write(log.getBytes());
        this.logStream.write(System.lineSeparator().getBytes());
        this.logStream.flush();
    }

    public static File[] findCompactionLogs(boolean isInnerSpace, String directory) {
        File timePartitionDir = new File(directory);
        if (timePartitionDir.exists()) {
            return timePartitionDir.listFiles((dir, name) -> {
                if (isInnerSpace) {
                    return name.endsWith(INNER_COMPACTION_LOG_NAME_SUFFIX);
                }
                return name.endsWith(CROSS_COMPACTION_LOG_NAME_SUFFIX) || name.endsWith(INSERTION_COMPACTION_LOG_NAME_SUFFIX);
            });
        }
        return new File[0];
    }

    public void force() throws IOException {
        this.logStream.flush();
        this.logStream.getFD().sync();
    }
}

