/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTimeMap;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashLastFlushTimeMap
implements ILastFlushTimeMap {
    private static final Logger logger = LoggerFactory.getLogger(HashLastFlushTimeMap.class);
    long STRING_BASE_SIZE = 40L;
    long LONG_SIZE = 24L;
    long HASHMAP_NODE_BASIC_SIZE = 14L + this.STRING_BASE_SIZE + this.LONG_SIZE;
    private final Map<Long, Map<String, Long>> partitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private final Map<String, Long> globalLatestFlushedTimeForEachDevice = new HashMap<String, Long>();
    TsFileManager tsFileManager;
    private final Map<Long, Long> memCostForEachPartition = new HashMap<Long, Long>();

    public HashLastFlushTimeMap(TsFileManager tsFileManager) {
        this.tsFileManager = tsFileManager;
    }

    @Override
    public void updateOneDeviceFlushedTime(long timePartitionId, String path, long time) {
        Map flushTimeMapForPartition = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
        flushTimeMapForPartition.compute(path, (k, v) -> {
            if (v == null) {
                v = this.recoverFlushTime(timePartitionId, path);
            }
            if (v == Long.MIN_VALUE) {
                long memCost = this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)path.length();
                this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? memCost : v1 + memCost);
                return time;
            }
            return Math.max(v, time);
        });
    }

    @Override
    public void updateMultiDeviceFlushedTime(long timePartitionId, Map<String, Long> flushedTimeMap) {
        Map flushTimeMapForPartition = this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
        long memIncr = 0L;
        for (Map.Entry<String, Long> entry : flushedTimeMap.entrySet()) {
            if (!flushTimeMapForPartition.containsKey(entry.getKey())) {
                memIncr += this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)entry.getKey().length();
            }
            flushTimeMapForPartition.merge(entry.getKey(), entry.getValue(), Math::max);
        }
        long finalMemIncr = memIncr;
        this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? finalMemIncr : v1 + finalMemIncr);
    }

    @Override
    public void updateOneDeviceGlobalFlushedTime(String path, long time) {
        this.globalLatestFlushedTimeForEachDevice.compute(path, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public void updateMultiDeviceGlobalFlushedTime(Map<String, Long> globalFlushedTimeMap) {
        for (Map.Entry<String, Long> entry : globalFlushedTimeMap.entrySet()) {
            this.globalLatestFlushedTimeForEachDevice.merge(entry.getKey(), entry.getValue(), Math::max);
        }
    }

    @Override
    public boolean checkAndCreateFlushedTimePartition(long timePartitionId) {
        if (!this.partitionLatestFlushedTimeForEachDevice.containsKey(timePartitionId)) {
            this.partitionLatestFlushedTimeForEachDevice.put(timePartitionId, new HashMap());
            return false;
        }
        return true;
    }

    @Override
    public void updateLatestFlushTime(long partitionId, Map<String, Long> updateMap) {
        for (Map.Entry<String, Long> entry : updateMap.entrySet()) {
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).merge(entry.getKey(), entry.getValue(), Math::max);
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long getFlushedTime(long timePartitionId, String path) {
        return this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId).computeIfAbsent(path, k -> this.recoverFlushTime(timePartitionId, path));
    }

    @Override
    public long getGlobalFlushedTime(String path) {
        return this.globalLatestFlushedTimeForEachDevice.getOrDefault(path, Long.MIN_VALUE);
    }

    @Override
    public void clearFlushedTime() {
        this.partitionLatestFlushedTimeForEachDevice.clear();
    }

    @Override
    public void clearGlobalFlushedTime() {
        this.globalLatestFlushedTimeForEachDevice.clear();
    }

    @Override
    public void removePartition(long partitionId) {
        this.partitionLatestFlushedTimeForEachDevice.remove(partitionId);
        this.memCostForEachPartition.remove(partitionId);
    }

    private long recoverFlushTime(long partitionId, String devicePath) {
        long memCost = this.HASHMAP_NODE_BASIC_SIZE + 2L * (long)devicePath.length();
        this.memCostForEachPartition.compute(partitionId, (k, v) -> v == null ? memCost : v + memCost);
        return this.tsFileManager.recoverFlushTimeFromTsFileResource(partitionId, devicePath);
    }

    @Override
    public long getMemSize(long partitionId) {
        if (this.memCostForEachPartition.containsKey(partitionId)) {
            return this.memCostForEachPartition.get(partitionId);
        }
        return 0L;
    }
}

