/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl;

import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class CreateTimeSeriesPlanImpl
implements ICreateTimeSeriesPlan {
    private PartialPath path;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private String alias;
    private Map<String, String> props = null;
    private Map<String, String> tags = null;
    private Map<String, String> attributes = null;
    private long tagOffset = -1L;

    public CreateTimeSeriesPlanImpl() {
    }

    public CreateTimeSeriesPlanImpl(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String alias) {
        this.path = path;
        this.dataType = dataType;
        this.encoding = encoding;
        this.compressor = compressor;
        this.tags = tags;
        this.attributes = attributes;
        this.alias = alias;
        if (props != null) {
            this.props = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.props.putAll(props);
        }
    }

    public CreateTimeSeriesPlanImpl(PartialPath path, MeasurementSchema schema) {
        this.path = path;
        this.dataType = schema.getType();
        this.encoding = schema.getEncodingType();
        this.compressor = schema.getCompressor();
    }

    @Override
    public PartialPath getPath() {
        return this.path;
    }

    @Override
    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public CompressionType getCompressor() {
        return this.compressor;
    }

    @Override
    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    @Override
    public TSEncoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public Map<String, String> getProps() {
        return this.props;
    }

    @Override
    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public long getTagOffset() {
        return this.tagOffset;
    }

    @Override
    public void setTagOffset(long tagOffset) {
        this.tagOffset = tagOffset;
    }
}

