/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.window.WindowType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class GroupByCountParameter
extends GroupByParameter {
    private final long countNumber;
    private final boolean ignoreNull;

    public GroupByCountParameter(long countNumber, boolean ignoreNull) {
        super(WindowType.COUNT_WINDOW);
        this.countNumber = countNumber;
        this.ignoreNull = ignoreNull;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((long)this.countNumber, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.ignoreNull, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.countNumber, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.ignoreNull, (OutputStream)stream);
    }

    public long getCountNumber() {
        return this.countNumber;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public static GroupByParameter deserialize(ByteBuffer buffer) {
        long countNumber = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
        boolean ignoreNull = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        return new GroupByCountParameter(countNumber, ignoreNull);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.countNumber == ((GroupByCountParameter)obj).getCountNumber() || this.ignoreNull == ((GroupByCountParameter)obj).isIgnoreNull();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.countNumber, this.ignoreNull);
    }
}

