/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.last;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LastQueryNode
extends MultiChildProcessNode {
    private final Filter timeFilter;
    private Ordering timeseriesOrdering;
    private boolean containsLastTransformNode;

    public LastQueryNode(PlanNodeId id, Filter timeFilter, @Nullable Ordering timeseriesOrdering, boolean containsLastTransformNode) {
        super(id);
        this.timeFilter = timeFilter;
        this.timeseriesOrdering = timeseriesOrdering;
        this.containsLastTransformNode = containsLastTransformNode;
    }

    public LastQueryNode(PlanNodeId id, List<PlanNode> children, Filter timeFilter, @Nullable Ordering timeseriesOrdering, boolean containsLastTransformNode) {
        super(id, children);
        this.timeFilter = timeFilter;
        this.timeseriesOrdering = timeseriesOrdering;
        this.containsLastTransformNode = containsLastTransformNode;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public PlanNode clone() {
        return new LastQueryNode(this.getPlanNodeId(), this.timeFilter, this.timeseriesOrdering, this.containsLastTransformNode);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    public String toString() {
        return String.format("LastQueryNode-%s:[TimeFilter: %s]", this.getPlanNodeId(), this.timeFilter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryNode that = (LastQueryNode)o;
        return Objects.equals(this.timeFilter, that.timeFilter) && this.timeseriesOrdering.equals((Object)that.timeseriesOrdering);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.timeFilter, this.timeseriesOrdering});
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQuery(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY.serialize(byteBuffer);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.timeFilter.serialize(byteBuffer);
        }
        if (this.timeseriesOrdering == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.timeseriesOrdering.ordinal(), (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY.serialize(stream);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.timeFilter.serialize(stream);
        }
        if (this.timeseriesOrdering == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.timeseriesOrdering.ordinal(), (OutputStream)stream);
        }
    }

    public static LastQueryNode deserialize(ByteBuffer byteBuffer) {
        Filter timeFilter = null;
        if (ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        byte needOrderByTimeseries = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Ordering timeseriesOrdering = null;
        if (needOrderByTimeseries == 1) {
            timeseriesOrdering = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryNode(planNodeId, timeFilter, timeseriesOrdering, false);
    }

    @Override
    public void setChildren(List<PlanNode> children) {
        this.children = children;
    }

    @Nullable
    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public Ordering getTimeseriesOrdering() {
        return this.timeseriesOrdering;
    }

    public void setTimeseriesOrdering(Ordering timeseriesOrdering) {
        this.timeseriesOrdering = timeseriesOrdering;
    }

    public boolean isContainsLastTransformNode() {
        return this.containsLastTransformNode;
    }

    public void setContainsLastTransformNode() {
        this.containsLastTransformNode = true;
    }

    public boolean needOrderByTimeseries() {
        return this.timeseriesOrdering != null;
    }
}

