/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LikeExpression
extends UnaryExpression {
    private final String patternString;
    private final Pattern pattern;

    public LikeExpression(Expression expression, String patternString) {
        super(expression);
        this.patternString = patternString;
        this.pattern = this.compile();
    }

    public LikeExpression(Expression expression, String patternString, Pattern pattern) {
        super(expression);
        this.patternString = patternString;
        this.pattern = pattern;
    }

    public LikeExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.patternString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.pattern = this.compile();
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private Pattern compile() {
        String unescapeValue = this.unescapeString(this.patternString);
        String specialRegexString = ".^$*+?{}[]|()";
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        for (int i = 0; i < unescapeValue.length(); ++i) {
            String ch = String.valueOf(unescapeValue.charAt(i));
            if (specialRegexString.contains(ch)) {
                ch = "\\" + unescapeValue.charAt(i);
            }
            if (i == 0 || !"\\".equals(String.valueOf(unescapeValue.charAt(i - 1))) || i >= 2 && "\\\\".equals(patternBuilder.substring(patternBuilder.length() - 2, patternBuilder.length()))) {
                patternBuilder.append(ch.replace("%", ".*?").replace("_", "."));
                continue;
            }
            patternBuilder.append(ch);
        }
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString());
    }

    private String unescapeString(String value) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int curIndex = 0; curIndex < value.length(); ++curIndex) {
            String ch = String.valueOf(value.charAt(curIndex));
            if ("\\".equals(ch)) {
                if (curIndex >= value.length() - 1) continue;
                String nextChar = String.valueOf(value.charAt(curIndex + 1));
                if ("%".equals(nextChar) || "_".equals(nextChar) || "\\".equals(nextChar)) {
                    stringBuilder.append(ch);
                }
                if (!"\\".equals(nextChar)) continue;
                ++curIndex;
                continue;
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getExpressionStringInternal() {
        return this.expression.getExpressionString() + " LIKE '" + this.pattern + "'";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.LIKE;
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new LikeExpression(childExpression, this.patternString, this.pattern);
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.patternString, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.patternString, (OutputStream)stream);
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression.getOutputSymbol() + " LIKE '" + this.pattern + "'";
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLikeExpression(this, context);
    }
}

