/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.previous;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumn;
import org.apache.iotdb.tsfile.read.common.block.column.BooleanColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class BooleanPreviousFill
implements IFill {
    private boolean value;
    private boolean previousIsNull = true;

    @Override
    public Column fill(Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (size == 0) {
            return valueColumn;
        }
        if (!valueColumn.mayHaveNull()) {
            this.previousIsNull = false;
            this.value = valueColumn.getBoolean(size - 1);
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            if (this.previousIsNull) {
                return new RunLengthEncodedColumn((Column)BooleanColumnBuilder.NULL_VALUE_BLOCK, size);
            }
            return new RunLengthEncodedColumn((Column)new BooleanColumn(1, Optional.empty(), new boolean[]{this.value}), size);
        }
        boolean[] array = new boolean[size];
        boolean[] isNull = new boolean[size];
        boolean hasNullValue = false;
        for (int i = 0; i < size; ++i) {
            if (valueColumn.isNull(i)) {
                if (this.previousIsNull) {
                    isNull[i] = true;
                    hasNullValue = true;
                    continue;
                }
                array[i] = this.value;
                continue;
            }
            array[i] = valueColumn.getBoolean(i);
            this.value = array[i];
            this.previousIsNull = false;
        }
        if (hasNullValue) {
            return new BooleanColumn(size, Optional.of(isNull), array);
        }
        return new BooleanColumn(size, Optional.empty(), array);
    }
}

