/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

public enum FragmentInstanceState {
    PLANNED(false, false),
    RUNNING(false, false),
    FLUSHING(false, false),
    FINISHED(true, false),
    CANCELLED(true, true),
    ABORTED(true, true),
    FAILED(true, true),
    NO_SUCH_INSTANCE(false, false);

    public static final Set<FragmentInstanceState> TERMINAL_INSTANCE_STATES;
    public static final Set<FragmentInstanceState> FAILURE_INSTANCE_STATES;
    private final boolean doneState;
    private final boolean failureState;

    private FragmentInstanceState(boolean doneState, boolean failureState) {
        this.doneState = doneState;
        this.failureState = failureState;
    }

    public boolean isDone() {
        return this.doneState;
    }

    public boolean isFailed() {
        return this.failureState;
    }

    static {
        TERMINAL_INSTANCE_STATES = (Set)Stream.of(FragmentInstanceState.values()).filter(FragmentInstanceState::isDone).collect(ImmutableSet.toImmutableSet());
        FAILURE_INSTANCE_STATES = (Set)Stream.of(FragmentInstanceState.values()).filter(FragmentInstanceState::isFailed).collect(ImmutableSet.toImmutableSet());
    }
}

