/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.LocalSinkChannel;
import org.apache.iotdb.db.queryengine.execution.exchange.source.LocalSourceHandle;
import org.apache.iotdb.db.queryengine.execution.memory.LocalMemoryManager;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SharedTsBlockQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedTsBlockQueue.class);
    private final TFragmentInstanceId localFragmentInstanceId;
    private final String localPlanNodeId;
    private final String fullFragmentInstanceId;
    private final LocalMemoryManager localMemoryManager;
    private boolean noMoreTsBlocks = false;
    private long bufferRetainedSizeInBytes = 0L;
    private final Queue<TsBlock> queue = new LinkedList<TsBlock>();
    private SettableFuture<Void> blocked = SettableFuture.create();
    private final SettableFuture<Void> canAddTsBlock = SettableFuture.create();
    private ListenableFuture<Void> blockedOnMemory;
    private boolean closed = false;
    private boolean alreadyRegistered = false;
    private LocalSourceHandle sourceHandle;
    private LocalSinkChannel sinkChannel;
    private long maxBytesCanReserve = IoTDBDescriptor.getInstance().getConfig().getMaxBytesPerFragmentInstance();
    private final ExecutorService executorService;

    public SharedTsBlockQueue(TFragmentInstanceId fragmentInstanceId, String planNodeId, LocalMemoryManager localMemoryManager, ExecutorService executorService) {
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)fragmentInstanceId, (String)"fragment instance ID cannot be null", (Object[])new Object[0]);
        this.fullFragmentInstanceId = FragmentInstanceId.createFragmentInstanceIdFromTFragmentInstanceId(this.localFragmentInstanceId);
        this.localPlanNodeId = (String)Validate.notNull((Object)planNodeId, (String)"PlanNode ID cannot be null", (Object[])new Object[0]);
        this.localMemoryManager = (LocalMemoryManager)Validate.notNull((Object)localMemoryManager, (String)"local memory manager cannot be null", (Object[])new Object[0]);
        this.executorService = (ExecutorService)Validate.notNull((Object)executorService, (String)"ExecutorService can not be null.", (Object[])new Object[0]);
    }

    public boolean hasNoMoreTsBlocks() {
        return this.noMoreTsBlocks;
    }

    public long getBufferRetainedSizeInBytes() {
        return this.bufferRetainedSizeInBytes;
    }

    public SettableFuture<Void> getCanAddTsBlock() {
        return this.canAddTsBlock;
    }

    public void setMaxBytesCanReserve(long maxBytesCanReserve) {
        this.maxBytesCanReserve = maxBytesCanReserve;
    }

    public long getMaxBytesCanReserve() {
        return this.maxBytesCanReserve;
    }

    public void allowAddingTsBlock() {
        if (!this.canAddTsBlock.isDone()) {
            this.canAddTsBlock.set(null);
        }
    }

    public ListenableFuture<Void> isBlocked() {
        if (!this.canAddTsBlock.isDone()) {
            this.canAddTsBlock.set(null);
        }
        return this.blocked;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getNumOfBufferedTsBlocks() {
        return this.queue.size();
    }

    public void setSinkChannel(LocalSinkChannel sinkChannel) {
        this.sinkChannel = sinkChannel;
    }

    public void setSourceHandle(LocalSourceHandle sourceHandle) {
        this.sourceHandle = sourceHandle;
    }

    public void setNoMoreTsBlocks(boolean noMoreTsBlocks) {
        LOGGER.debug("[SignalNoMoreTsBlockOnQueue]");
        if (this.closed) {
            LOGGER.debug("The queue has been destroyed when calling setNoMoreTsBlocks.");
            return;
        }
        this.noMoreTsBlocks = noMoreTsBlocks;
        if (!this.blocked.isDone()) {
            this.blocked.set(null);
        }
        if (this.sourceHandle != null) {
            this.sourceHandle.checkAndInvokeOnFinished();
        }
    }

    public TsBlock remove() {
        if (this.closed) {
            throw new IllegalStateException("queue has been destroyed");
        }
        TsBlock tsBlock = this.queue.remove();
        this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, tsBlock.getRetainedSizeInBytes());
        this.bufferRetainedSizeInBytes -= tsBlock.getRetainedSizeInBytes();
        if (this.sinkChannel != null) {
            this.sinkChannel.checkAndInvokeOnFinished();
        }
        if (this.blocked.isDone() && this.queue.isEmpty() && !this.noMoreTsBlocks) {
            this.blocked = SettableFuture.create();
        }
        return tsBlock;
    }

    public ListenableFuture<Void> add(TsBlock tsBlock) {
        if (this.closed) {
            return Futures.immediateVoidFuture();
        }
        Validate.notNull((Object)tsBlock, (String)"TsBlock cannot be null", (Object[])new Object[0]);
        Validate.isTrue((this.blockedOnMemory == null || this.blockedOnMemory.isDone() ? 1 : 0) != 0, (String)"SharedTsBlockQueue is full", (Object[])new Object[0]);
        if (!this.alreadyRegistered) {
            this.localMemoryManager.getQueryPool().registerPlanNodeIdToQueryMemoryMap(this.localFragmentInstanceId.queryId, this.fullFragmentInstanceId, this.localPlanNodeId);
            this.alreadyRegistered = true;
        }
        Pair<ListenableFuture<Void>, Boolean> pair = this.localMemoryManager.getQueryPool().reserve(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, tsBlock.getRetainedSizeInBytes(), this.maxBytesCanReserve);
        this.blockedOnMemory = (ListenableFuture)pair.left;
        this.bufferRetainedSizeInBytes += tsBlock.getRetainedSizeInBytes();
        if (!Boolean.TRUE.equals(pair.right)) {
            SettableFuture channelBlocked = SettableFuture.create();
            this.blockedOnMemory.addListener(() -> {
                SharedTsBlockQueue sharedTsBlockQueue = this;
                synchronized (sharedTsBlockQueue) {
                    this.queue.add(tsBlock);
                    if (!this.blocked.isDone()) {
                        this.blocked.set(null);
                    }
                    channelBlocked.set(null);
                }
            }, (Executor)this.executorService);
            return channelBlocked;
        }
        this.queue.add(tsBlock);
        if (!this.blocked.isDone()) {
            this.blocked.set(null);
        }
        return this.blockedOnMemory;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.blocked.isDone()) {
            this.blocked.set(null);
        }
        if (!this.canAddTsBlock.isDone()) {
            this.canAddTsBlock.set(null);
        }
        if (this.blockedOnMemory != null) {
            this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
        }
        this.queue.clear();
        if (this.bufferRetainedSizeInBytes > 0L) {
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
            this.bufferRetainedSizeInBytes = 0L;
        }
        if (this.sinkChannel != null) {
            this.sinkChannel.close();
        }
    }

    public void abort() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.blocked.isDone()) {
            this.blocked.cancel(true);
        }
        if (!this.canAddTsBlock.isDone()) {
            this.canAddTsBlock.set(null);
        }
        if (this.blockedOnMemory != null) {
            this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
        }
        this.queue.clear();
        if (this.bufferRetainedSizeInBytes > 0L) {
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
            this.bufferRetainedSizeInBytes = 0L;
        }
    }

    public void abort(Throwable t) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.blocked.isDone()) {
            this.blocked.setException(t);
        }
        if (!this.canAddTsBlock.isDone()) {
            this.canAddTsBlock.set(null);
        }
        if (this.blockedOnMemory != null) {
            this.bufferRetainedSizeInBytes -= this.localMemoryManager.getQueryPool().tryCancel(this.blockedOnMemory);
        }
        this.queue.clear();
        if (this.bufferRetainedSizeInBytes > 0L) {
            this.localMemoryManager.getQueryPool().free(this.localFragmentInstanceId.getQueryId(), this.fullFragmentInstanceId, this.localPlanNodeId, this.bufferRetainedSizeInBytes);
            this.bufferRetainedSizeInBytes = 0L;
        }
    }
}

