/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator;

import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.utils.TimeDuration;

public class AggrWindowIterator
implements ITimeRangeIterator {
    private final long startTime;
    private final long endTime;
    private final TimeDuration interval;
    private final TimeDuration slidingStep;
    private final boolean isAscending;
    private final boolean leftCRightO;
    private TimeRange curTimeRange;
    private boolean hasCachedTimeRange;

    public AggrWindowIterator(long startTime, long endTime, TimeDuration interval, TimeDuration slidingStep, boolean isAscending, boolean leftCRightO) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
        this.isAscending = isAscending;
        this.leftCRightO = leftCRightO;
    }

    @Override
    public TimeRange getFirstTimeRange() {
        if (this.isAscending) {
            return this.getLeftmostTimeRange();
        }
        return this.getRightmostTimeRange();
    }

    private TimeRange getLeftmostTimeRange() {
        long retEndTime = this.interval.containsMonth() ? Math.min(DateTimeUtils.calcPositiveIntervalByMonth(this.startTime, this.interval, 1L), this.endTime) : Math.min(this.startTime + this.interval.nonMonthDuration, this.endTime);
        return new TimeRange(this.startTime, retEndTime);
    }

    private TimeRange getRightmostTimeRange() {
        long retStartTime;
        long queryRange = this.endTime - this.startTime;
        if (this.slidingStep.containsMonth()) {
            long tempRetStartTime;
            long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep.getMaxTotalDuration(TimestampPrecisionUtils.currPrecision));
            retStartTime = tempRetStartTime = DateTimeUtils.calcPositiveIntervalByMonth(this.startTime, this.slidingStep, intervalNum - 1L);
            while (tempRetStartTime < this.endTime) {
                retStartTime = tempRetStartTime;
                tempRetStartTime = DateTimeUtils.calcPositiveIntervalByMonth(retStartTime, this.slidingStep, 1L);
            }
        } else {
            long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep.nonMonthDuration);
            retStartTime = this.slidingStep.nonMonthDuration * (intervalNum - 1L) + this.startTime;
        }
        long retEndTime = this.interval.containsMonth() ? Math.min(DateTimeUtils.calcPositiveIntervalByMonth(retStartTime, this.interval, 1L), this.endTime) : Math.min(retStartTime + this.interval.nonMonthDuration, this.endTime);
        return new TimeRange(retStartTime, retEndTime);
    }

    @Override
    public boolean hasNextTimeRange() {
        long retStartTime;
        if (this.hasCachedTimeRange) {
            return true;
        }
        if (this.curTimeRange == null) {
            this.curTimeRange = this.getFirstTimeRange();
            this.hasCachedTimeRange = true;
            return true;
        }
        long curStartTime = this.curTimeRange.getMin();
        if (this.isAscending ? (retStartTime = this.slidingStep.containsMonth() ? DateTimeUtils.calcPositiveIntervalByMonth(curStartTime, this.slidingStep, 1L) : curStartTime + this.slidingStep.nonMonthDuration) >= this.endTime : (retStartTime = this.slidingStep.containsMonth() ? DateTimeUtils.calcNegativeIntervalByMonth(curStartTime, this.slidingStep) : curStartTime - this.slidingStep.nonMonthDuration) < this.startTime) {
            return false;
        }
        long retEndTime = this.interval.containsMonth() ? DateTimeUtils.calcPositiveIntervalByMonth(retStartTime, this.interval, 1L) : retStartTime + this.interval.nonMonthDuration;
        retEndTime = Math.min(retEndTime, this.endTime);
        this.curTimeRange = new TimeRange(retStartTime, retEndTime);
        this.hasCachedTimeRange = true;
        return true;
    }

    @Override
    public TimeRange nextTimeRange() {
        if (this.hasCachedTimeRange || this.hasNextTimeRange()) {
            this.hasCachedTimeRange = false;
            return this.getFinalTimeRange(this.curTimeRange, this.leftCRightO);
        }
        return null;
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }

    @Override
    public long currentOutputTime() {
        return this.leftCRightO ? this.curTimeRange.getMin() : this.curTimeRange.getMax();
    }

    @Override
    public long getTotalIntervalNum() {
        long intervalNum;
        long queryRange = this.endTime - this.startTime;
        if (this.slidingStep.containsMonth()) {
            intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep.getMaxTotalDuration(TimestampPrecisionUtils.currPrecision));
            long retStartTime = DateTimeUtils.calcPositiveIntervalByMonth(this.startTime, this.slidingStep, intervalNum);
            while (retStartTime < this.endTime) {
                ++intervalNum;
                retStartTime = DateTimeUtils.calcPositiveIntervalByMonth(retStartTime, this.slidingStep, 1L);
            }
        } else {
            intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep.nonMonthDuration);
        }
        return intervalNum;
    }

    public void reset() {
        this.curTimeRange = null;
        this.hasCachedTimeRange = false;
    }
}

