/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.header;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ColumnHeader {
    private final String columnName;
    private final TSDataType dataType;
    private final String alias;

    public ColumnHeader(String columnName, TSDataType dataType, String alias) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.alias = alias;
    }

    public ColumnHeader(String columnName, TSDataType dataType) {
        this.columnName = columnName;
        this.dataType = dataType;
        this.alias = null;
    }

    public String getColumnNameWithAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public TSDataType getColumnType() {
        return this.dataType;
    }

    public boolean hasAlias() {
        return this.alias != null && !this.alias.isEmpty();
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.columnName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.dataType.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.hasAlias(), (ByteBuffer)byteBuffer);
        if (this.hasAlias()) {
            ReadWriteIOUtils.write((String)this.alias, (ByteBuffer)byteBuffer);
        }
        this.dataType.serializeTo(byteBuffer);
    }

    public static ColumnHeader deserialize(ByteBuffer byteBuffer) {
        String columnName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        TSDataType dataType = TSDataType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        String alias = null;
        boolean hasAlias = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (hasAlias) {
            alias = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        }
        return new ColumnHeader(columnName, dataType, alias);
    }

    public String toString() {
        if (this.hasAlias()) {
            return String.format("%s(%s) [%s]", this.columnName, this.alias, this.dataType);
        }
        return String.format("%s [%s]", this.columnName, this.dataType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnHeader that = (ColumnHeader)o;
        return Objects.equals(this.columnName, that.columnName) && this.dataType == that.dataType && Objects.equals(this.alias, that.alias);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.dataType, this.alias);
    }
}

