/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.processor;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtask;
import org.apache.iotdb.db.pipe.task.subtask.processor.PipeProcessorSubtaskWorker;

public class PipeProcessorSubtaskWorkerManager {
    private static final int MAX_THREAD_NUM = PipeConfig.getInstance().getPipeSubtaskExecutorMaxThreadNum();
    private final PipeProcessorSubtaskWorker[] workers = new PipeProcessorSubtaskWorker[MAX_THREAD_NUM];
    private final AtomicLong scheduledTaskNumber;

    public PipeProcessorSubtaskWorkerManager(ListeningExecutorService workerThreadPoolExecutor) {
        for (int i = 0; i < MAX_THREAD_NUM; ++i) {
            this.workers[i] = new PipeProcessorSubtaskWorker();
            workerThreadPoolExecutor.submit((Runnable)((Object)this.workers[i]));
        }
        this.scheduledTaskNumber = new AtomicLong(0L);
    }

    public void schedule(PipeProcessorSubtask pipeProcessorSubtask) {
        this.workers[(int)(this.scheduledTaskNumber.getAndIncrement() % (long)MAX_THREAD_NUM)].schedule(pipeProcessorSubtask);
    }
}

