/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHardlinkFileDirStartupCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHardlinkFileDirStartupCleaner.class);

    public static void clean() {
        for (String dataDir : IoTDBDescriptor.getInstance().getConfig().getDataDirs()) {
            for (File file : FileUtils.listFilesAndDirs((File)new File(dataDir), (IOFileFilter)DirectoryFileFilter.INSTANCE, (IOFileFilter)DirectoryFileFilter.INSTANCE)) {
                if (!file.isDirectory() || !file.getName().equals(PipeConfig.getInstance().getPipeHardlinkBaseDirName())) continue;
                LOGGER.info("pipe hardlink dir found, deleting it: {}, result: {}", (Object)file, (Object)FileUtils.deleteQuietly((File)file));
            }
        }
    }

    private PipeHardlinkFileDirStartupCleaner() {
    }
}

