/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime.epoch;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpochStateMigrator;
import org.apache.iotdb.db.pipe.metric.PipeExtractorMetrics;

public class TsFileEpoch {
    private final String filePath;
    private final ConcurrentMap<PipeRealtimeDataRegionExtractor, AtomicReference<State>> dataRegionExtractor2State;

    public TsFileEpoch(String filePath) {
        this.filePath = filePath;
        this.dataRegionExtractor2State = new ConcurrentHashMap<PipeRealtimeDataRegionExtractor, AtomicReference<State>>();
    }

    public State getState(PipeRealtimeDataRegionExtractor extractor) {
        return (State)((Object)this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).get());
    }

    public void migrateState(PipeRealtimeDataRegionExtractor extractor, TsFileEpochStateMigrator visitor) {
        this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).getAndUpdate(visitor::migrate);
    }

    public void setExtractorsRecentProcessedTsFileEpochState() {
        this.dataRegionExtractor2State.forEach((extractor, state) -> PipeExtractorMetrics.getInstance().setRecentProcessedTsFileEpochState(extractor.getTaskID(), (State)((Object)((Object)state.get()))));
    }

    public String toString() {
        return "TsFileEpoch{filePath='" + this.filePath + '\'' + ", dataRegionExtractor2State=" + this.dataRegionExtractor2State + '}';
    }

    public static enum State {
        EMPTY(0),
        USING_TABLET(1),
        USING_BOTH(2),
        USING_TSFILE(3);

        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

