/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.TabletInsertionDataContainer;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.tsfile.write.record.Tablet;

public class PipeRawTabletInsertionEvent
extends EnrichedEvent
implements TabletInsertionEvent {
    private final Tablet tablet;
    private final boolean isAligned;
    private final EnrichedEvent sourceEvent;
    private boolean needToReport;
    private PipeMemoryBlock allocatedMemoryBlock;
    private TabletInsertionDataContainer dataContainer;

    private PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, EnrichedEvent sourceEvent, boolean needToReport, PipeTaskMeta pipeTaskMeta, String pattern) {
        super(pipeTaskMeta, pattern);
        this.tablet = Objects.requireNonNull(tablet);
        this.isAligned = isAligned;
        this.sourceEvent = sourceEvent;
        this.needToReport = needToReport;
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, boolean needToReport) {
        this(tablet, isAligned, sourceEvent, needToReport, pipeTaskMeta, null);
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned) {
        this(tablet, isAligned, null, false, null, null);
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, String pattern) {
        this(tablet, isAligned, null, false, null, pattern);
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        this.allocatedMemoryBlock = PipeResourceManager.memory().forceAllocate(this.tablet);
        return true;
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        this.allocatedMemoryBlock.close();
        return true;
    }

    @Override
    protected void reportProgress() {
        if (this.needToReport) {
            super.reportProgress();
        }
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return this.sourceEvent != null ? this.sourceEvent.getProgressIndex() : MinimumProgressIndex.INSTANCE;
    }

    @Override
    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta pipeTaskMeta, String pattern) {
        return new PipeRawTabletInsertionEvent(this.tablet, this.isAligned, this.sourceEvent, this.needToReport, pipeTaskMeta, pattern);
    }

    @Override
    public boolean isGeneratedByPipe() {
        throw new UnsupportedOperationException("isGeneratedByPipe() is not supported!");
    }

    public void markAsNeedToReport() {
        this.needToReport = true;
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.getPattern());
        }
        return this.dataContainer.processRowByRow(consumer);
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.getPattern());
        }
        return this.dataContainer.processTablet(consumer);
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public Tablet convertToTablet() {
        if (!this.shouldParsePatternOrTime()) {
            return this.tablet;
        }
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.getPattern());
        }
        return this.dataContainer.convertToTablet();
    }

    public TabletInsertionEvent parseEventWithPattern() {
        return new PipeRawTabletInsertionEvent(this.convertToTablet(), this.isAligned, this.pipeTaskMeta, this, this.needToReport);
    }
}

