/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.opcua;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.db.pipe.config.constant.PipeConnectorConstant;
import org.apache.iotdb.db.pipe.connector.protocol.opcua.OpcUaServerBuilder;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaConnector.class);
    private static final Map<String, Pair<AtomicInteger, OpcUaServer>> SERVER_KEY_TO_REFERENCE_COUNT_AND_SERVER_MAP = new ConcurrentHashMap<String, Pair<AtomicInteger, OpcUaServer>>();
    private String serverKey;
    private OpcUaServer server;

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        int tcpBindPort = parameters.getIntOrDefault(Arrays.asList("connector.opcua.tcp.port", "sink.opcua.tcp.port"), 12686);
        int httpsBindPort = parameters.getIntOrDefault(Arrays.asList("connector.opcua.https.port", "sink.opcua.https.port"), 8443);
        String user = parameters.getStringOrDefault(Arrays.asList("connector.user", "sink.user"), "root");
        String password = parameters.getStringOrDefault(Arrays.asList("connector.password", "sink.password"), "root");
        String securityDir = parameters.getStringOrDefault(Arrays.asList("connector.opcua.security.dir", "sink.opcua.security.dir"), PipeConnectorConstant.CONNECTOR_OPC_UA_SECURITY_DIR_DEFAULT_VALUE);
        Map<String, Pair<AtomicInteger, OpcUaServer>> map = SERVER_KEY_TO_REFERENCE_COUNT_AND_SERVER_MAP;
        synchronized (map) {
            this.serverKey = httpsBindPort + ":" + tcpBindPort;
            this.server = (OpcUaServer)SERVER_KEY_TO_REFERENCE_COUNT_AND_SERVER_MAP.computeIfAbsent(this.serverKey, key -> {
                try {
                    OpcUaServer newServer = new OpcUaServerBuilder().setTcpBindPort(tcpBindPort).setHttpsBindPort(httpsBindPort).setUser(user).setPassword(password).setSecurityDir(securityDir).build();
                    newServer.startup();
                    return new Pair((Object)new AtomicInteger(0), (Object)newServer);
                }
                catch (Exception e) {
                    throw new PipeException("Failed to build and startup OpcUaServer", (Throwable)e);
                }
            }).getRight();
            ((AtomicInteger)SERVER_KEY_TO_REFERENCE_COUNT_AND_SERVER_MAP.get(this.serverKey).getLeft()).incrementAndGet();
        }
    }

    public void handshake() throws Exception {
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(Event event) throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("OpcUaConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Ignore {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            this.transferTablet(this.server, ((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).convertToTablet());
        } else {
            this.transferTablet(this.server, ((PipeRawTabletInsertionEvent)tabletInsertionEvent).convertToTablet());
        }
    }

    private void transferTablet(OpcUaServer server, Tablet tablet) throws UaException {
        int pseudoNameSpaceIndex = 0;
        BaseEventTypeNode eventNode = server.getEventFactory().createEvent(new NodeId(pseudoNameSpaceIndex, UUID.randomUUID()), Identifiers.BaseEventType);
        for (int columnIndex = 0; columnIndex < tablet.getSchemas().size(); ++columnIndex) {
            TSDataType dataType = ((MeasurementSchema)tablet.getSchemas().get(columnIndex)).getType();
            eventNode.setSourceName(tablet.deviceId + "." + ((MeasurementSchema)tablet.getSchemas().get(columnIndex)).getMeasurementId());
            eventNode.setSourceNode(this.convertToOpcDataType(dataType));
            for (int rowIndex = 0; rowIndex < tablet.rowSize; ++rowIndex) {
                if (tablet.bitMaps[columnIndex].isMarked(rowIndex)) continue;
                eventNode.setTime(new DateTime(tablet.timestamps[rowIndex]));
                switch (dataType) {
                    case BOOLEAN: {
                        eventNode.setMessage(LocalizedText.english((String)Boolean.toString(((boolean[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case INT32: {
                        eventNode.setMessage(LocalizedText.english((String)Integer.toString(((int[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case INT64: {
                        eventNode.setMessage(LocalizedText.english((String)Long.toString(((long[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case FLOAT: {
                        eventNode.setMessage(LocalizedText.english((String)Float.toString(((float[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case DOUBLE: {
                        eventNode.setMessage(LocalizedText.english((String)Double.toString(((double[])tablet.values[columnIndex])[rowIndex])));
                        break;
                    }
                    case TEXT: {
                        eventNode.setMessage(LocalizedText.english((String)((Binary[])tablet.values[columnIndex])[rowIndex].toString()));
                        break;
                    }
                    default: {
                        throw new PipeRuntimeNonCriticalException("Unsupported data type: " + ((MeasurementSchema)tablet.getSchemas().get(columnIndex)).getType());
                    }
                }
                server.getEventBus().post((Object)eventNode);
            }
        }
        eventNode.delete();
    }

    private NodeId convertToOpcDataType(TSDataType type) {
        switch (type) {
            case BOOLEAN: {
                return Identifiers.Boolean;
            }
            case INT32: {
                return Identifiers.Int32;
            }
            case INT64: {
                return Identifiers.Int64;
            }
            case FLOAT: {
                return Identifiers.Float;
            }
            case DOUBLE: {
                return Identifiers.Double;
            }
            case TEXT: {
                return Identifiers.String;
            }
        }
        throw new PipeRuntimeNonCriticalException("Unsupported data type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.serverKey == null) {
            return;
        }
        Map<String, Pair<AtomicInteger, OpcUaServer>> map = SERVER_KEY_TO_REFERENCE_COUNT_AND_SERVER_MAP;
        synchronized (map) {
            Pair<AtomicInteger, OpcUaServer> pair = SERVER_KEY_TO_REFERENCE_COUNT_AND_SERVER_MAP.get(this.serverKey);
            if (pair == null) {
                return;
            }
            if (((AtomicInteger)pair.getLeft()).decrementAndGet() <= 0) {
                try {
                    ((OpcUaServer)pair.getRight()).shutdown();
                }
                finally {
                    SERVER_KEY_TO_REFERENCE_COUNT_AND_SERVER_MAP.remove(this.serverKey);
                }
            }
        }
    }
}

