/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.session.util.SessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConnector.class);
    protected final List<TEndPoint> nodeUrls = new ArrayList<TEndPoint>();
    protected boolean isTabletBatchModeEnabled = true;

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false && (Boolean)args[2] != false || (Boolean)args[3] != false || (Boolean)args[4] != false && (Boolean)args[5] != false, String.format("One of %s, %s:%s, %s, %s:%s must be specified", "connector.node-urls", "connector.ip", "connector.port", "sink.node-urls", "sink.ip", "sink.port"), new Object[]{parameters.hasAttribute("connector.node-urls"), parameters.hasAttribute("connector.ip"), parameters.hasAttribute("connector.port"), parameters.hasAttribute("sink.node-urls"), parameters.hasAttribute("sink.ip"), parameters.hasAttribute("sink.port")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.nodeUrls.clear();
        this.nodeUrls.addAll(this.parseNodeUrls(parameters));
        LOGGER.info("IoTDBConnector nodeUrls: {}", this.nodeUrls);
        this.isTabletBatchModeEnabled = parameters.getBooleanOrDefault(Arrays.asList("connector.batch.enable", "sink.batch.enable"), true);
        LOGGER.info("IoTDBConnector isTabletBatchModeEnabled: {}", (Object)this.isTabletBatchModeEnabled);
    }

    protected Set<TEndPoint> parseNodeUrls(PipeParameters parameters) {
        HashSet<TEndPoint> givenNodeUrls = new HashSet<TEndPoint>(this.nodeUrls);
        if (parameters.hasAttribute("connector.ip") && parameters.hasAttribute("connector.port")) {
            givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"connector.ip"}), parameters.getIntByKeys(new String[]{"connector.port"}).intValue()));
        }
        if (parameters.hasAttribute("sink.ip") && parameters.hasAttribute("sink.port")) {
            givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"sink.ip"}), parameters.getIntByKeys(new String[]{"sink.port"}).intValue()));
        }
        if (parameters.hasAttribute("connector.node-urls")) {
            givenNodeUrls.addAll(SessionUtils.parseSeedNodeUrls(Arrays.asList(parameters.getStringByKeys(new String[]{"connector.node-urls"}).split(","))));
        }
        if (parameters.hasAttribute("sink.node-urls")) {
            givenNodeUrls.addAll(SessionUtils.parseSeedNodeUrls(Arrays.asList(parameters.getStringByKeys(new String[]{"sink.node-urls"}).split(","))));
        }
        return givenNodeUrls;
    }
}

