/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.protocol.IoTDBConnectorRequestVersion;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;

public class PipeTransferTabletBatchReq
extends TPipeTransferReq {
    private final transient List<PipeTransferTabletBinaryReq> binaryReqs = new ArrayList<PipeTransferTabletBinaryReq>();
    private final transient List<PipeTransferTabletInsertNodeReq> insertNodeReqs = new ArrayList<PipeTransferTabletInsertNodeReq>();
    private final transient List<PipeTransferTabletRawReq> tabletReqs = new ArrayList<PipeTransferTabletRawReq>();

    private PipeTransferTabletBatchReq() {
    }

    public Pair<InsertRowsStatement, InsertMultiTabletsStatement> constructStatements() {
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (PipeTransferTabletBinaryReq binaryReq : this.binaryReqs) {
            Statement statement = binaryReq.constructStatement();
            if (statement instanceof InsertRowStatement) {
                insertRowStatementList.add((InsertRowStatement)statement);
                continue;
            }
            if (statement instanceof InsertTabletStatement) {
                insertTabletStatementList.add((InsertTabletStatement)statement);
                continue;
            }
            throw new UnsupportedOperationException(String.format("unknown InsertBaseStatement %s constructed from PipeTransferTabletBinaryReq.", new Object[]{binaryReq}));
        }
        for (PipeTransferTabletInsertNodeReq insertNodeReq : this.insertNodeReqs) {
            Statement insertStatement = insertNodeReq.constructStatement();
            if (insertStatement instanceof InsertRowStatement) {
                insertRowStatementList.add((InsertRowStatement)insertStatement);
                continue;
            }
            if (insertStatement instanceof InsertTabletStatement) {
                insertTabletStatementList.add((InsertTabletStatement)insertStatement);
                continue;
            }
            throw new UnsupportedOperationException(String.format("unknown InsertBaseStatement %s constructed from PipeTransferTabletInsertNodeReq.", new Object[]{insertNodeReq}));
        }
        for (PipeTransferTabletRawReq tabletReq : this.tabletReqs) {
            insertTabletStatementList.add(tabletReq.constructStatement());
        }
        insertRowsStatement.setInsertRowStatementList(insertRowStatementList);
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        return new Pair((Object)insertRowsStatement, (Object)insertMultiTabletsStatement);
    }

    public static PipeTransferTabletBatchReq toTPipeTransferReq(List<TPipeTransferReq> reqs) throws IOException {
        PipeTransferTabletBatchReq batchReq = new PipeTransferTabletBatchReq();
        for (TPipeTransferReq req : reqs) {
            if (req instanceof PipeTransferTabletBinaryReq) {
                batchReq.binaryReqs.add((PipeTransferTabletBinaryReq)req);
                continue;
            }
            if (req instanceof PipeTransferTabletInsertNodeReq) {
                batchReq.insertNodeReqs.add((PipeTransferTabletInsertNodeReq)req);
                continue;
            }
            if (req instanceof PipeTransferTabletRawReq) {
                batchReq.tabletReqs.add((PipeTransferTabletRawReq)req);
                continue;
            }
            throw new UnsupportedOperationException(String.format("unknown TPipeTransferReq type %s when constructing PipeTransferTabletBatchReq", req.getType()));
        }
        batchReq.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        batchReq.type = PipeRequestType.TRANSFER_TABLET_BATCH.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)batchReq.binaryReqs.size(), (OutputStream)outputStream);
            for (PipeTransferTabletBinaryReq binaryReq : batchReq.binaryReqs) {
                ReadWriteIOUtils.write((int)binaryReq.getBody().length, (OutputStream)outputStream);
                outputStream.write(binaryReq.getBody());
            }
            ReadWriteIOUtils.write((int)batchReq.insertNodeReqs.size(), (OutputStream)outputStream);
            for (PipeTransferTabletInsertNodeReq insertNodeReq : batchReq.insertNodeReqs) {
                insertNodeReq.getInsertNode().serialize(outputStream);
            }
            ReadWriteIOUtils.write((int)batchReq.tabletReqs.size(), (OutputStream)outputStream);
            for (PipeTransferTabletRawReq tabletReq : batchReq.tabletReqs) {
                tabletReq.getTablet().serialize(outputStream);
                ReadWriteIOUtils.write((Boolean)tabletReq.getIsAligned(), (OutputStream)outputStream);
            }
            batchReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return batchReq;
    }

    public static PipeTransferTabletBatchReq fromTPipeTransferReq(TPipeTransferReq transferReq) throws IOException {
        int i;
        PipeTransferTabletBatchReq batchReq = new PipeTransferTabletBatchReq();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            int length = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
            byte[] body = new byte[length];
            transferReq.body.get(body);
            batchReq.binaryReqs.add(PipeTransferTabletBinaryReq.toTPipeTransferReq(ByteBuffer.wrap(body)));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            batchReq.insertNodeReqs.add(PipeTransferTabletInsertNodeReq.toTPipeTransferReq((InsertNode)PlanFragment.deserializeHelper(transferReq.body)));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            batchReq.tabletReqs.add(PipeTransferTabletRawReq.toTPipeTransferReq(Tablet.deserialize((ByteBuffer)transferReq.body), ReadWriteIOUtils.readBool((ByteBuffer)transferReq.body)));
        }
        batchReq.version = transferReq.version;
        batchReq.type = transferReq.type;
        batchReq.body = transferReq.body;
        return batchReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletBatchReq that = (PipeTransferTabletBatchReq)((Object)obj);
        return this.binaryReqs.equals(that.binaryReqs) && this.insertNodeReqs.equals(that.insertNodeReqs) && this.tabletReqs.equals(that.tabletReqs) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.binaryReqs, this.insertNodeReqs, this.tabletReqs, this.version, this.type, this.body);
    }
}

