/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.plugin;

import java.util.Arrays;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.plugin.builtin.connector.DoNothingConnector;
import org.apache.iotdb.commons.pipe.plugin.meta.DataNodePipePluginMetaKeeper;
import org.apache.iotdb.db.pipe.agent.plugin.PipePluginConstructor;
import org.apache.iotdb.db.pipe.connector.protocol.legacy.IoTDBLegacyPipeConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBThriftSyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.websocket.WebSocketConnector;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeConnectorConstructor
extends PipePluginConstructor {
    PipeConnectorConstructor(DataNodePipePluginMetaKeeper pipePluginMetaKeeper) {
        super(pipePluginMetaKeeper);
    }

    @Override
    protected void initConstructors() {
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName(), IoTDBThriftAsyncConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_THRIFT_SYNC_CONNECTOR.getPipePluginName(), IoTDBThriftSyncConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_THRIFT_ASYNC_CONNECTOR.getPipePluginName(), IoTDBThriftAsyncConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_LEGACY_PIPE_CONNECTOR.getPipePluginName(), IoTDBLegacyPipeConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.WEBSOCKET_CONNECTOR.getPipePluginName(), WebSocketConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.DO_NOTHING_CONNECTOR.getPipePluginName(), DoNothingConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_THRIFT_SINK.getPipePluginName(), IoTDBThriftAsyncConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_THRIFT_SYNC_SINK.getPipePluginName(), IoTDBThriftSyncConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_THRIFT_ASYNC_SINK.getPipePluginName(), IoTDBThriftAsyncConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.IOTDB_LEGACY_PIPE_SINK.getPipePluginName(), IoTDBLegacyPipeConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.WEBSOCKET_SINK.getPipePluginName(), WebSocketConnector::new);
        PLUGIN_CONSTRUCTORS.put(BuiltinPipePlugin.DO_NOTHING_SINK.getPipePluginName(), DoNothingConnector::new);
    }

    PipeConnector reflectPlugin(PipeParameters connectorParameters) {
        if (!connectorParameters.hasAnyAttributes(new String[]{"connector", "sink"})) {
            throw new PipeException("Failed to reflect PipeConnector instance because 'connector' is not specified in the parameters.");
        }
        return (PipeConnector)this.reflectPluginByKey(connectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase());
    }
}

