/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli.utils;

import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IoTPrinter {
    private static final PrintStream SCREEN_PRINTER = new PrintStream(System.out);

    private IoTPrinter() {
    }

    public static void printf(String format, Object ... args) {
        SCREEN_PRINTER.printf(format, args);
    }

    public static void print(String msg) {
        SCREEN_PRINTER.print(msg);
    }

    public static void printException(Exception msg) {
        SCREEN_PRINTER.println(msg);
    }

    public static void println() {
        SCREEN_PRINTER.println();
    }

    public static void println(String msg) {
        SCREEN_PRINTER.println(msg);
    }

    public static void printBlockLine(List<Integer> maxSizeList) {
        StringBuilder blockLine = new StringBuilder();
        for (Integer integer : maxSizeList) {
            blockLine.append("+").append(StringUtils.repeat((String)"-", (int)integer));
        }
        blockLine.append("+");
        IoTPrinter.println(blockLine.toString());
    }

    public static void printRow(List<List<String>> lists, int i, List<Integer> maxSizeList) {
        IoTPrinter.printf("|", new Object[0]);
        for (int j = 0; j < maxSizeList.size(); ++j) {
            int maxSize = maxSizeList.get(j);
            String element = lists.get(j).get(i);
            int count = IoTPrinter.computeHANCount(element);
            if (count > 0) {
                int remain = maxSize - (element.length() + count);
                if (remain > 0) {
                    StringBuilder paddingStr = IoTPrinter.padding(remain);
                    maxSize -= count;
                    element = paddingStr.append(element).toString();
                } else if (remain == 0) {
                    maxSize -= count;
                }
            }
            IoTPrinter.printf("%" + maxSize + "s|", element);
        }
        IoTPrinter.println();
    }

    public static void printCount(int cnt) {
        if (cnt == 0) {
            IoTPrinter.println("Empty set.");
        } else {
            IoTPrinter.println("Total line number = " + cnt);
        }
    }

    public static StringBuilder padding(int count) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < count; ++k) {
            sb.append(' ');
        }
        return sb;
    }

    public static int computeHANCount(String s) {
        return (int)s.codePoints().filter(codePoint -> Character.UnicodeScript.of(codePoint) == Character.UnicodeScript.HAN).count();
    }
}

