/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;

public class Role {
    private String name;
    private List<PathPrivilege> pathPrivilegeList;
    private Set<Integer> sysPrivilegeSet;
    private Set<Integer> sysPriGrantOpt;
    private static final int SYS_PRI_SIZE = PrivilegeType.getSysPriCount();
    private boolean serviceReady = true;

    public Role() {
    }

    public Role(String name) {
        this.name = name;
        this.pathPrivilegeList = new ArrayList<PathPrivilege>();
        this.sysPrivilegeSet = new HashSet<Integer>();
        this.sysPriGrantOpt = new HashSet<Integer>();
    }

    public String getName() {
        return this.name;
    }

    public List<PathPrivilege> getPathPrivilegeList() {
        return this.pathPrivilegeList;
    }

    public Set<Integer> getSysPrivilege() {
        return this.sysPrivilegeSet;
    }

    public Set<Integer> getPathPrivileges(PartialPath path) {
        return AuthUtils.getPrivileges(path, this.pathPrivilegeList);
    }

    public Set<Integer> getSysPriGrantOpt() {
        return this.sysPriGrantOpt;
    }

    public int getAllSysPrivileges() {
        int privs = 0;
        for (Integer sysPri : this.sysPrivilegeSet) {
            privs |= 1 << this.sysPriTopos(sysPri);
        }
        for (Integer sysGrantOpt : this.sysPriGrantOpt) {
            privs |= 1 << this.sysPriTopos(sysGrantOpt) + 16;
        }
        return privs;
    }

    public boolean getServiceReady() {
        return this.serviceReady;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrivilegeList(List<PathPrivilege> privilegeList) {
        this.pathPrivilegeList = privilegeList;
    }

    public void setPathPrivileges(PartialPath path, Set<Integer> privileges) {
        for (PathPrivilege pathPrivilege : this.pathPrivilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            pathPrivilege.setPrivileges(privileges);
        }
    }

    public void addPathPrivilege(PartialPath path, int privilegeId, boolean grantOpt) {
        AuthUtils.addPrivilege(path, privilegeId, this.pathPrivilegeList, grantOpt);
    }

    public void removePathPrivilege(PartialPath path, int privilegeId) {
        AuthUtils.removePrivilege(path, privilegeId, this.pathPrivilegeList);
    }

    public void setSysPrivilegeSet(Set<Integer> privilegeSet) {
        this.sysPrivilegeSet = privilegeSet;
    }

    public void setSysPriGrantOpt(Set<Integer> grantOpt) {
        this.sysPriGrantOpt = grantOpt;
    }

    private int posToSysPri(int pos) {
        switch (pos) {
            case 0: {
                return PrivilegeType.MANAGE_DATABASE.ordinal();
            }
            case 1: {
                return PrivilegeType.MANAGE_USER.ordinal();
            }
            case 2: {
                return PrivilegeType.MANAGE_ROLE.ordinal();
            }
            case 3: {
                return PrivilegeType.USE_TRIGGER.ordinal();
            }
            case 4: {
                return PrivilegeType.USE_UDF.ordinal();
            }
            case 5: {
                return PrivilegeType.USE_CQ.ordinal();
            }
            case 6: {
                return PrivilegeType.USE_PIPE.ordinal();
            }
            case 7: {
                return PrivilegeType.EXTEND_TEMPLATE.ordinal();
            }
            case 8: {
                return PrivilegeType.MAINTAIN.ordinal();
            }
            case 9: {
                return PrivilegeType.USE_MODEL.ordinal();
            }
        }
        return -1;
    }

    private int sysPriTopos(int privilegeId) {
        PrivilegeType type = PrivilegeType.values()[privilegeId];
        switch (type) {
            case MANAGE_DATABASE: {
                return 0;
            }
            case MANAGE_USER: {
                return 1;
            }
            case MANAGE_ROLE: {
                return 2;
            }
            case USE_TRIGGER: {
                return 3;
            }
            case USE_UDF: {
                return 4;
            }
            case USE_CQ: {
                return 5;
            }
            case USE_PIPE: {
                return 6;
            }
            case EXTEND_TEMPLATE: {
                return 7;
            }
            case MAINTAIN: {
                return 8;
            }
            case USE_MODEL: {
                return 9;
            }
        }
        return -1;
    }

    public void setSysPrivilegeSet(int privilegeMask) {
        if (this.sysPrivilegeSet == null) {
            this.sysPrivilegeSet = new HashSet<Integer>();
        }
        if (this.sysPriGrantOpt == null) {
            this.sysPriGrantOpt = new HashSet<Integer>();
        }
        for (int i = 0; i < SYS_PRI_SIZE; ++i) {
            if ((privilegeMask & 1 << i) != 0) {
                this.sysPrivilegeSet.add(this.posToSysPri(i));
            }
            if ((privilegeMask & 1 << i + 16) == 0) continue;
            this.sysPriGrantOpt.add(this.posToSysPri(i));
        }
    }

    public void addSysPrivilege(int privilegeId) {
        this.sysPrivilegeSet.add(privilegeId);
    }

    public void removeSysPrivilege(int privilegeId) {
        this.sysPrivilegeSet.remove(privilegeId);
    }

    public void setServiceReady(boolean ready) {
        this.serviceReady = ready;
    }

    public boolean hasPrivilegeToRevoke(PartialPath path, int privilegeId) {
        if (path == null) {
            return this.sysPrivilegeSet.contains(privilegeId);
        }
        return AuthUtils.hasPrivilegeToReovke(path, privilegeId, this.pathPrivilegeList);
    }

    public boolean checkPathPrivilege(PartialPath path, int privilegeId) {
        return AuthUtils.checkPathPrivilege(path, privilegeId, this.pathPrivilegeList);
    }

    public boolean checkPathPrivilegeGrantOpt(PartialPath path, int privilegeId) {
        return AuthUtils.checkPathPrivilegeGrantOpt(path, privilegeId, this.pathPrivilegeList);
    }

    public boolean checkSysPrivilege(int privilegeId) {
        return this.sysPrivilegeSet.contains(privilegeId);
    }

    public boolean checkSysPriGrantOpt(int privilegeId) {
        return this.sysPrivilegeSet.contains(privilegeId) && this.sysPriGrantOpt.contains(privilegeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.name, role.name) && Objects.equals(this.pathPrivilegeList, role.pathPrivilegeList) && Objects.equals(this.sysPrivilegeSet, role.sysPrivilegeSet) && Objects.equals(this.sysPriGrantOpt, role.sysPriGrantOpt);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pathPrivilegeList, this.sysPrivilegeSet);
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize(this.name, dataOutputStream);
        try {
            dataOutputStream.writeInt(this.sysPrivilegeSet.size());
            for (Integer item : this.sysPrivilegeSet) {
                dataOutputStream.writeInt(item);
            }
            dataOutputStream.writeInt(this.sysPriGrantOpt.size());
            for (Integer item : this.sysPriGrantOpt) {
                dataOutputStream.writeInt(item);
            }
            dataOutputStream.writeInt(this.pathPrivilegeList.size());
            for (PathPrivilege pathPrivilege : this.pathPrivilegeList) {
                dataOutputStream.write(pathPrivilege.serialize().array());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.name = SerializeUtils.deserializeString(buffer);
        int sysPrivilegeSize = buffer.getInt();
        this.sysPrivilegeSet = new HashSet<Integer>();
        for (int i = 0; i < sysPrivilegeSize; ++i) {
            this.sysPrivilegeSet.add(buffer.getInt());
        }
        int sysPriGrantOptSize = buffer.getInt();
        this.sysPriGrantOpt = new HashSet<Integer>();
        for (int i = 0; i < sysPriGrantOptSize; ++i) {
            this.sysPriGrantOpt.add(buffer.getInt());
        }
        int privilegeListSize = buffer.getInt();
        this.pathPrivilegeList = new ArrayList<PathPrivilege>(privilegeListSize);
        for (int i = 0; i < privilegeListSize; ++i) {
            PathPrivilege pathPrivilege = new PathPrivilege();
            pathPrivilege.deserialize(buffer);
            this.pathPrivilegeList.add(pathPrivilege);
        }
    }

    public String toString() {
        return "Role{name='" + this.name + '\'' + ", pathPrivilegeList=" + this.pathPrivilegeList + ", systemPrivilegeSet=" + this.sysPrivilegeSet + '}';
    }
}

