/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPrivilege {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathPrivilege.class);
    private static final int PATH_PRI_SIZE = PrivilegeType.getPathPriCount();
    private Set<Integer> privileges;
    private Set<Integer> grantOpts;
    private PartialPath path;

    public PathPrivilege() {
    }

    public PathPrivilege(PartialPath path) {
        this.path = path;
        this.privileges = new HashSet<Integer>();
        this.grantOpts = new HashSet<Integer>();
    }

    public Set<Integer> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(Set<Integer> privileges) {
        this.privileges = privileges;
    }

    public Set<Integer> getGrantOpt() {
        return this.grantOpts;
    }

    public void setGrantOpt(Set<Integer> grantOpts) {
        this.grantOpts = grantOpts;
    }

    public void grantPrivilege(int privilege, boolean grantOpt) {
        this.privileges.add(privilege);
        if (grantOpt) {
            this.grantOpts.add(privilege);
        }
    }

    public boolean revokePrivilege(int privilege) {
        if (!this.privileges.contains(privilege)) {
            LOGGER.warn("not find privilege{} on path {}", (Object)PrivilegeType.values()[privilege], (Object)this.path);
            return false;
        }
        this.privileges.remove(privilege);
        this.grantOpts.remove(privilege);
        return true;
    }

    public boolean revokeGrantOpt(int privilege) {
        if (!this.privileges.contains(privilege)) {
            LOGGER.warn("path {} dont have privilege {}", (Object)this.path, (Object)PrivilegeType.values()[privilege]);
            return false;
        }
        this.grantOpts.remove(privilege);
        return true;
    }

    public boolean checkPrivilege(int privilege) {
        if (this.privileges.contains(privilege)) {
            return true;
        }
        if (privilege == PrivilegeType.READ_DATA.ordinal()) {
            return this.privileges.contains(PrivilegeType.WRITE_DATA.ordinal());
        }
        if (privilege == PrivilegeType.READ_SCHEMA.ordinal()) {
            return this.privileges.contains(PrivilegeType.WRITE_SCHEMA.ordinal());
        }
        return false;
    }

    private int posToPri(int pos) {
        switch (pos) {
            case 0: {
                return PrivilegeType.READ_DATA.ordinal();
            }
            case 1: {
                return PrivilegeType.WRITE_DATA.ordinal();
            }
            case 2: {
                return PrivilegeType.READ_SCHEMA.ordinal();
            }
            case 3: {
                return PrivilegeType.WRITE_SCHEMA.ordinal();
            }
        }
        return -1;
    }

    private int priToPos(PrivilegeType pri) {
        switch (pri) {
            case READ_DATA: {
                return 0;
            }
            case WRITE_DATA: {
                return 1;
            }
            case READ_SCHEMA: {
                return 2;
            }
            case WRITE_SCHEMA: {
                return 3;
            }
        }
        return -1;
    }

    public void setAllPrivileges(int privs) {
        for (int i = 0; i < PATH_PRI_SIZE; ++i) {
            if ((1 << i & privs) != 0) {
                this.privileges.add(this.posToPri(i));
            }
            if ((1 << i + 16 & privs) == 0) continue;
            this.grantOpts.add(this.posToPri(i));
        }
    }

    public int getAllPrivileges() {
        int privilege = 0;
        for (Integer pri : this.privileges) {
            privilege |= 1 << this.priToPos(PrivilegeType.values()[pri]);
        }
        for (Integer grantOpt : this.grantOpts) {
            privilege |= 1 << this.priToPos(PrivilegeType.values()[grantOpt]) + 16;
        }
        return privilege;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPrivilege that = (PathPrivilege)o;
        return Objects.equals(this.privileges, that.privileges) && Objects.equals(this.path, that.path) && Objects.equals(this.grantOpts, this.grantOpts);
    }

    public int hashCode() {
        return Objects.hash(this.privileges, this.grantOpts, this.path);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.path.getFullPath());
        builder.append(" :");
        for (Integer privilegeId : this.privileges) {
            builder.append(" ").append((Object)PrivilegeType.values()[privilegeId]);
            if (!this.grantOpts.contains(privilegeId)) continue;
            builder.append("_").append("with_grant_option");
        }
        return builder.toString();
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serializeIntSet(this.privileges, dataOutputStream);
        SerializeUtils.serializeIntSet(this.grantOpts, dataOutputStream);
        try {
            this.path.serialize(dataOutputStream);
        }
        catch (IOException exception) {
            LOGGER.error("Unexpected exception when serialize path", (Throwable)exception);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.privileges = new HashSet<Integer>();
        SerializeUtils.deserializeIntSet(this.privileges, buffer);
        this.grantOpts = new HashSet<Integer>();
        SerializeUtils.deserializeIntSet(this.grantOpts, buffer);
        this.path = (PartialPath)PathDeserializeUtil.deserialize(buffer);
    }
}

