/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.unsafequeues;

import io.moquette.broker.unsafequeues.QueueException;
import io.moquette.broker.unsafequeues.QueuePool;
import io.moquette.broker.unsafequeues.Segment;
import io.moquette.broker.unsafequeues.SegmentAllocator;
import io.moquette.broker.unsafequeues.SegmentPointer;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;

class PagedFilesAllocator
implements SegmentAllocator {
    private final Path pagesFolder;
    private final int pageSize;
    private final int segmentSize;
    private int lastSegmentAllocated;
    private int lastPage;
    private MappedByteBuffer currentPage;
    private FileChannel currentPageFile;

    PagedFilesAllocator(Path pagesFolder, int pageSize, int segmentSize, int lastPage, int lastSegmentAllocated) throws QueueException {
        if (pageSize % segmentSize != 0) {
            throw new IllegalArgumentException("The pageSize must be an exact multiple of the segmentSize");
        }
        this.pagesFolder = pagesFolder;
        this.pageSize = pageSize;
        this.segmentSize = segmentSize;
        this.lastPage = lastPage;
        this.lastSegmentAllocated = lastSegmentAllocated;
        this.currentPage = this.openRWPageFile(this.pagesFolder, this.lastPage);
    }

    private MappedByteBuffer openRWPageFile(Path pagesFolder, int pageId) throws QueueException {
        MappedByteBuffer mappedByteBuffer;
        block13: {
            Path pageFile = pagesFolder.resolve(String.format("%d.page", pageId));
            boolean createNew = false;
            if (!Files.exists(pageFile, new LinkOption[0])) {
                try {
                    pageFile.toFile().createNewFile();
                    createNew = true;
                }
                catch (IOException ex) {
                    throw new QueueException("Reached an IO error during the bootstrapping of empty 'checkpoint.properties'", ex);
                }
            }
            FileChannel fileChannel = FileChannel.open(pageFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
            try {
                this.currentPageFile = fileChannel;
                MappedByteBuffer mappedPage = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.pageSize);
                if (createNew && QueuePool.queueDebug) {
                    for (int i = 0; i < this.pageSize; ++i) {
                        mappedPage.put(i, (byte)67);
                    }
                }
                mappedByteBuffer = mappedPage;
                if (fileChannel == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new QueueException("Can't open page file " + pageFile, e);
                }
            }
            fileChannel.close();
        }
        return mappedByteBuffer;
    }

    @Override
    public Segment nextFreeSegment() throws QueueException {
        if (this.currentPageIsExhausted()) {
            ++this.lastPage;
            this.currentPage = this.openRWPageFile(this.pagesFolder, this.lastPage);
            this.lastSegmentAllocated = 0;
        }
        int beginOffset = this.lastSegmentAllocated * this.segmentSize;
        int endOffset = (this.lastSegmentAllocated + 1) * this.segmentSize - 1;
        ++this.lastSegmentAllocated;
        return new Segment(this.currentPage, new SegmentPointer(this.lastPage, (long)beginOffset), new SegmentPointer(this.lastPage, (long)endOffset));
    }

    @Override
    public Segment reopenSegment(int pageId, int beginOffset) throws QueueException {
        MappedByteBuffer page = this.openRWPageFile(this.pagesFolder, pageId);
        SegmentPointer begin = new SegmentPointer(pageId, (long)beginOffset);
        SegmentPointer end = new SegmentPointer(pageId, (long)(beginOffset + this.segmentSize - 1));
        return new Segment(page, begin, end);
    }

    @Override
    public void close() throws QueueException {
        if (this.currentPageFile != null) {
            try {
                this.currentPageFile.close();
            }
            catch (IOException ex) {
                throw new QueueException("Problem closing current page file", ex);
            }
        }
    }

    @Override
    public void dumpState(Properties checkpoint) {
        checkpoint.setProperty("segments.last_page", String.valueOf(this.lastPage));
        checkpoint.setProperty("segments.last_segment", String.valueOf(this.lastSegmentAllocated));
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getSegmentSize() {
        return this.segmentSize;
    }

    private boolean currentPageIsExhausted() {
        return this.lastSegmentAllocated * this.segmentSize == this.pageSize;
    }

    static interface AllocationListener {
        public void segmentedCreated(String var1, Segment var2);
    }
}

