/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.Checkpoint;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointType;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.MemTablePinException;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.CheckpointWriter;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.ILogWriter;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.CheckpointFileUtils;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALInsertNodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CheckpointManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final WritingMetrics WRITING_METRICS = WritingMetrics.getInstance();
    protected final String identifier;
    protected final String logDirectory;
    private final Lock infoLock = new ReentrantLock();
    private final Map<Long, MemTableInfo> memTableId2Info = new HashMap<Long, MemTableInfo>();
    private volatile ByteBuffer cachedByteBuffer;
    private long maxMemTableId = 0L;
    private long currentCheckPointFileVersion = 0L;
    private ILogWriter currentLogWriter;

    public CheckpointManager(String identifier, String logDirectory) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = logDirectory;
        File logDirFile = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!logDirFile.exists() && logDirFile.mkdirs()) {
            logger.info("create folder {} for wal buffer-{}.", (Object)logDirectory, (Object)identifier);
        }
        this.currentLogWriter = new CheckpointWriter(SystemFileFactory.INSTANCE.getFile(logDirectory, CheckpointFileUtils.getLogFileName(this.currentCheckPointFileVersion)));
        this.logHeader();
    }

    public List<MemTableInfo> snapshotMemTableInfos() {
        this.infoLock.lock();
        try {
            ArrayList<MemTableInfo> arrayList = new ArrayList<MemTableInfo>(this.memTableId2Info.values());
            return arrayList;
        }
        finally {
            this.infoLock.unlock();
        }
    }

    private void logHeader() {
        this.infoLock.lock();
        try {
            ByteBuffer tmpBuffer = ByteBuffer.allocate(8);
            tmpBuffer.putLong(this.maxMemTableId);
            try {
                this.currentLogWriter.write(tmpBuffer);
            }
            catch (IOException e) {
                logger.error("Fail to log max memTable id: {}", (Object)this.maxMemTableId, (Object)e);
            }
            this.makeGlobalInfoCP();
        }
        finally {
            this.infoLock.unlock();
        }
    }

    private void makeGlobalInfoCP() {
        long start = System.nanoTime();
        List<MemTableInfo> memTableInfos = this.snapshotMemTableInfos();
        memTableInfos.removeIf(MemTableInfo::isFlushed);
        Checkpoint checkpoint = new Checkpoint(CheckpointType.GLOBAL_MEMORY_TABLE_INFO, memTableInfos);
        this.logByCachedByteBuffer(checkpoint);
        this.fsyncCheckpointFile();
        WRITING_METRICS.recordMakeCheckpointCost(checkpoint.getType(), System.nanoTime() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCreateMemTableCPInMemory(MemTableInfo memTableInfo) {
        this.infoLock.lock();
        long start = System.nanoTime();
        try {
            this.maxMemTableId = Math.max(this.maxMemTableId, memTableInfo.getMemTableId());
            this.memTableId2Info.put(memTableInfo.getMemTableId(), memTableInfo);
        }
        finally {
            WRITING_METRICS.recordMakeCheckpointCost(CheckpointType.CREATE_MEMORY_TABLE, System.nanoTime() - start);
            this.infoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeCreateMemTableCPOnDisk(long memTableId) {
        this.infoLock.lock();
        long start = System.nanoTime();
        try {
            MemTableInfo memTableInfo = this.memTableId2Info.get(memTableId);
            if (memTableInfo == null) {
                return;
            }
            Checkpoint checkpoint = new Checkpoint(CheckpointType.CREATE_MEMORY_TABLE, Collections.singletonList(memTableInfo));
            this.logByCachedByteBuffer(checkpoint);
        }
        finally {
            WRITING_METRICS.recordMakeCheckpointCost(CheckpointType.CREATE_MEMORY_TABLE, System.nanoTime() - start);
            this.infoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeFlushMemTableCP(long memTableId) {
        this.infoLock.lock();
        long start = System.nanoTime();
        try {
            MemTableInfo memTableInfo = this.memTableId2Info.get(memTableId);
            if (memTableInfo == null) {
                return;
            }
            memTableInfo.setFlushed();
            if (!memTableInfo.isPinned()) {
                this.memTableId2Info.remove(memTableId);
            }
            Checkpoint checkpoint = new Checkpoint(CheckpointType.FLUSH_MEMORY_TABLE, Collections.singletonList(memTableInfo));
            this.logByCachedByteBuffer(checkpoint);
        }
        finally {
            WRITING_METRICS.recordMakeCheckpointCost(CheckpointType.FLUSH_MEMORY_TABLE, System.nanoTime() - start);
            this.infoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logByCachedByteBuffer(Checkpoint checkpoint) {
        int estimateSize = checkpoint.serializedSize();
        if (this.cachedByteBuffer == null || estimateSize > this.cachedByteBuffer.capacity()) {
            this.cachedByteBuffer = ByteBuffer.allocate(estimateSize);
        }
        checkpoint.serialize(this.cachedByteBuffer);
        try {
            this.currentLogWriter.write(this.cachedByteBuffer);
        }
        catch (IOException e) {
            logger.error("Fail to make checkpoint: {}", (Object)checkpoint, (Object)e);
        }
        finally {
            this.cachedByteBuffer.clear();
        }
    }

    public void fsyncCheckpointFile() {
        this.infoLock.lock();
        try {
            try {
                this.currentLogWriter.force();
            }
            catch (IOException e) {
                logger.error("Fail to fsync wal node-{}'s checkpoint writer, change system mode to error.", (Object)this.identifier, (Object)e);
                CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
            }
            try {
                if (this.tryRollingLogWriter()) {
                    this.logHeader();
                    this.currentLogWriter.force();
                    File oldFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, CheckpointFileUtils.getLogFileName(this.currentCheckPointFileVersion - 1L));
                    Files.delete(oldFile.toPath());
                }
            }
            catch (IOException e) {
                logger.error("Fail to roll wal node-{}'s checkpoint writer, change system mode to error.", (Object)this.identifier, (Object)e);
                CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
            }
        }
        finally {
            this.infoLock.unlock();
        }
    }

    private boolean tryRollingLogWriter() throws IOException {
        if (this.currentLogWriter.size() < config.getCheckpointFileSizeThresholdInByte()) {
            return false;
        }
        this.currentLogWriter.close();
        ++this.currentCheckPointFileVersion;
        File nextLogFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, CheckpointFileUtils.getLogFileName(this.currentCheckPointFileVersion));
        this.currentLogWriter = new CheckpointWriter(nextLogFile);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pinMemTable(long memTableId) throws MemTablePinException {
        this.infoLock.lock();
        try {
            if (!this.memTableId2Info.containsKey(memTableId)) {
                throw new MemTablePinException(String.format("Fail to pin memTable-%d because this memTable doesn't exist in the wal.", memTableId));
            }
            MemTableInfo memTableInfo = this.memTableId2Info.get(memTableId);
            if (!memTableInfo.isPinned()) {
                WALInsertNodeCache.getInstance(memTableInfo.getDataRegionId()).addMemTable(memTableId);
            }
            memTableInfo.pin();
        }
        finally {
            this.infoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpinMemTable(long memTableId) throws MemTablePinException {
        this.infoLock.lock();
        try {
            if (!this.memTableId2Info.containsKey(memTableId)) {
                throw new MemTablePinException(String.format("Fail to unpin memTable-%d because this memTable doesn't exist in the wal.", memTableId));
            }
            if (!this.memTableId2Info.get(memTableId).isPinned()) {
                throw new MemTablePinException(String.format("Fail to unpin memTable-%d because this memTable hasn't been pinned.", memTableId));
            }
            MemTableInfo memTableInfo = this.memTableId2Info.get(memTableId);
            memTableInfo.unpin();
            if (!memTableInfo.isPinned()) {
                WALInsertNodeCache.getInstance(memTableInfo.getDataRegionId()).removeMemTable(memTableId);
                if (memTableInfo.isFlushed()) {
                    this.memTableId2Info.remove(memTableId);
                }
            }
        }
        finally {
            this.infoLock.unlock();
        }
    }

    public MemTableInfo getOldestMemTableInfo() {
        List<MemTableInfo> memTableInfos = this.snapshotMemTableInfos();
        if (memTableInfos.isEmpty()) {
            return null;
        }
        MemTableInfo oldestMemTableInfo = memTableInfos.get(0);
        for (MemTableInfo memTableInfo : memTableInfos) {
            if (oldestMemTableInfo.getFirstFileVersionId() <= memTableInfo.getFirstFileVersionId()) continue;
            oldestMemTableInfo = memTableInfo;
        }
        return oldestMemTableInfo;
    }

    public long getFirstValidWALVersionId() {
        List<MemTableInfo> memTableInfos = this.snapshotMemTableInfos();
        long firstValidVersionId = memTableInfos.isEmpty() ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (MemTableInfo memTableInfo : memTableInfos) {
            firstValidVersionId = Math.min(firstValidVersionId, memTableInfo.getFirstFileVersionId());
        }
        return firstValidVersionId;
    }

    public long getTotalCostOfActiveMemTables() {
        List<MemTableInfo> memTableInfos = this.snapshotMemTableInfos();
        long totalCost = 0L;
        for (MemTableInfo memTableInfo : memTableInfos) {
            if (memTableInfo.isFlushed()) continue;
            if (config.isEnableMemControl()) {
                totalCost += memTableInfo.getMemTable().getTVListsRamCost();
                continue;
            }
            ++totalCost;
        }
        return totalCost;
    }

    public int getRegionId(long memtableId) {
        MemTableInfo info = this.memTableId2Info.get(memtableId);
        if (info == null) {
            logger.warn("memtableId {} not found in MemTableId2Info", (Object)memtableId);
            return -1;
        }
        return Integer.parseInt(info.getMemTable().getDataRegionId());
    }

    @Override
    public void close() {
        this.infoLock.lock();
        try {
            if (this.currentLogWriter != null) {
                try {
                    this.currentLogWriter.close();
                }
                catch (IOException e) {
                    logger.error("Fail to close wal node-{}'s checkpoint writer.", (Object)this.identifier, (Object)e);
                }
            }
        }
        finally {
            this.infoLock.unlock();
        }
    }
}

