/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.DiskChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskChunkMetadataLoader
implements IChunkMetadataLoader {
    private final TsFileResource resource;
    private final QueryContext context;
    private final Filter filter;
    private final List<Modification> pathModifications;
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();

    public DiskChunkMetadataLoader(TsFileResource resource, QueryContext context, Filter filter, List<Modification> pathModifications) {
        this.resource = resource;
        this.context = context;
        this.filter = filter;
        this.pathModifications = pathModifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IChunkMetadata> loadChunkMetadataList(ITimeSeriesMetadata timeSeriesMetadata) {
        long t1 = System.nanoTime();
        try {
            List chunkMetadataList = ((TimeseriesMetadata)timeSeriesMetadata).getCopiedChunkMetadataList();
            long t2 = System.nanoTime();
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("Modifications size is {} for file Path: {} ", (Object)this.pathModifications.size(), (Object)this.resource.getTsFilePath());
                this.pathModifications.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            if (!this.pathModifications.isEmpty()) {
                ModificationUtils.modifyChunkMetaData(chunkMetadataList, this.pathModifications);
            }
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("After modification Chunk meta data list is: ");
                chunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("chunk_metadata_modification_non_aligned_disk", System.nanoTime() - t2);
            chunkMetadataList.forEach(chunkMetadata -> {
                if (chunkMetadata.needSetChunkLoader()) {
                    chunkMetadata.setFilePath(this.resource.getTsFilePath());
                    chunkMetadata.setClosed(this.resource.isClosed());
                    chunkMetadata.setChunkLoader((IChunkLoader)new DiskChunkLoader(this.context.isDebug()));
                }
            });
            long t3 = System.nanoTime();
            chunkMetadataList.removeIf(chunkMetaData -> this.filter != null && !this.filter.satisfyStartEndTime(chunkMetaData.getStartTime(), chunkMetaData.getEndTime()) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("chunk_metadata_filter_non_aligned_disk", System.nanoTime() - t3);
            if (this.context.isDebug()) {
                DEBUG_LOGGER.info("After removed by filter Chunk meta data list is: ");
                chunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
            }
            List list = chunkMetadataList;
            return list;
        }
        finally {
            SERIES_SCAN_COST_METRIC_SET.recordSeriesScanCost("load_chunk_metadata_list_non_aligned_disk", System.nanoTime() - t1);
        }
    }
}

