/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class QueryDataSource {
    private final List<TsFileResource> seqResources;
    private final List<TsFileResource> unseqResources;
    private int[] unSeqFileOrderIndex;
    private long dataTTL = Long.MAX_VALUE;
    private static final Comparator<Long> descendingComparator = (o1, o2) -> Long.compare(o2, o1);

    public QueryDataSource(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        this.seqResources = seqResources;
        this.unseqResources = unseqResources;
    }

    public List<TsFileResource> getSeqResources() {
        return this.seqResources;
    }

    public List<TsFileResource> getUnseqResources() {
        return this.unseqResources;
    }

    public long getDataTTL() {
        return this.dataTTL;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
    }

    public TsFileResource getSeqResourceByIndex(int curIndex) {
        if (curIndex < this.seqResources.size()) {
            return this.seqResources.get(curIndex);
        }
        return null;
    }

    public TsFileResource getUnseqResourceByIndex(int curIndex) {
        int actualIndex = this.unSeqFileOrderIndex[curIndex];
        if (actualIndex < this.unseqResources.size()) {
            return this.unseqResources.get(actualIndex);
        }
        return null;
    }

    public boolean hasNextSeqResource(int curIndex, boolean ascending) {
        return ascending ? curIndex < this.seqResources.size() : curIndex >= 0;
    }

    public boolean hasNextUnseqResource(int curIndex) {
        return curIndex < this.unseqResources.size();
    }

    public int getSeqResourcesSize() {
        return this.seqResources.size();
    }

    public int getUnseqResourcesSize() {
        return this.unseqResources.size();
    }

    public void fillOrderIndexes(String deviceId, boolean ascending) {
        TreeMap<Long, List> orderTimeToIndexMap = ascending ? new TreeMap<Long, List>() : new TreeMap(descendingComparator);
        int index = 0;
        for (TsFileResource resource : this.unseqResources) {
            orderTimeToIndexMap.computeIfAbsent(resource.getOrderTime(deviceId, ascending), key -> new ArrayList()).add(index++);
        }
        index = 0;
        int[] unSeqFileOrderIndexArray = new int[this.unseqResources.size()];
        for (List orderIndexes : orderTimeToIndexMap.values()) {
            for (Integer orderIndex : orderIndexes) {
                unSeqFileOrderIndexArray[index++] = orderIndex;
            }
        }
        this.unSeqFileOrderIndex = unSeqFileOrderIndexArray;
    }
}

