/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;

public class DataNodeDevicePathCache {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Cache<String, PartialPath> devicePathCache = Caffeine.newBuilder().maximumSize((long)config.getDevicePathCacheSize()).build();

    private DataNodeDevicePathCache() {
    }

    public static DataNodeDevicePathCache getInstance() {
        return DataNodeDevicePathCacheHolder.INSTANCE;
    }

    public PartialPath getPartialPath(String deviceId) throws IllegalPathException {
        try {
            return (PartialPath)this.devicePathCache.get((Object)deviceId, path -> {
                try {
                    return new PartialPath(path);
                }
                catch (IllegalPathException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new IllegalPathException(deviceId);
        }
    }

    public void cleanUp() {
        this.devicePathCache.cleanUp();
    }

    private static class DataNodeDevicePathCacheHolder {
        private static final DataNodeDevicePathCache INSTANCE = new DataNodeDevicePathCache();

        private DataNodeDevicePathCacheHolder() {
        }
    }
}

