/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.MeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaEntityNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaInternalNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeDeviceVisitor;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitorFactory;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitorWithLimitOffsetWrapper;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class ClusterSchemaTree
implements ISchemaTree {
    private Set<String> databases;
    private final SchemaNode root;
    private boolean hasLogicalMeasurementPath = false;

    public ClusterSchemaTree() {
        this.root = new SchemaInternalNode("root");
    }

    public ClusterSchemaTree(SchemaNode root) {
        this.root = root;
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern, int slimit, int soffset, boolean isPrefixMatch) {
        try (SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor = SchemaTreeVisitorFactory.createSchemaTreeMeasurementVisitor(this.root, pathPattern, isPrefixMatch, slimit, soffset);){
            Pair pair = new Pair(visitor.getAllResult(), (Object)visitor.getNextOffset());
            return pair;
        }
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> searchMeasurementPaths(PartialPath pathPattern) {
        try (SchemaTreeVisitorWithLimitOffsetWrapper<MeasurementPath> visitor = SchemaTreeVisitorFactory.createSchemaTreeMeasurementVisitor(this.root, pathPattern, false, 0, 0);){
            Pair pair = new Pair(visitor.getAllResult(), (Object)visitor.getNextOffset());
            return pair;
        }
    }

    public List<MeasurementPath> getAllMeasurement() {
        return (List)this.searchMeasurementPaths((PartialPath)SchemaConstant.ALL_MATCH_PATTERN, (int)0, (int)0, (boolean)false).left;
    }

    @Override
    public List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) {
        try (SchemaTreeDeviceVisitor visitor = SchemaTreeVisitorFactory.createSchemaTreeDeviceVisitor(this.root, pathPattern, isPrefixMatch);){
            List<DeviceSchemaInfo> list = visitor.getAllResult();
            return list;
        }
    }

    @Override
    public List<DeviceSchemaInfo> getMatchedDevices(PartialPath pathPattern) {
        try (SchemaTreeDeviceVisitor visitor = SchemaTreeVisitorFactory.createSchemaTreeDeviceVisitor(this.root, pathPattern, false);){
            List<DeviceSchemaInfo> list = visitor.getAllResult();
            return list;
        }
    }

    @Override
    public DeviceSchemaInfo searchDeviceSchemaInfo(PartialPath devicePath, List<String> measurements) {
        String[] nodes = devicePath.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                return null;
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur == null) {
            return null;
        }
        ArrayList<MeasurementSchemaInfo> measurementSchemaInfoList = new ArrayList<MeasurementSchemaInfo>();
        for (String measurement : measurements) {
            SchemaNode node = cur.getChild(measurement);
            if (node == null) {
                measurementSchemaInfoList.add(null);
                continue;
            }
            SchemaMeasurementNode measurementNode = node.getAsMeasurementNode();
            measurementSchemaInfoList.add(new MeasurementSchemaInfo(measurementNode.getName(), measurementNode.getSchema(), measurementNode.getAlias()));
        }
        return new DeviceSchemaInfo(devicePath, cur.getAsEntityNode().isAligned(), measurementSchemaInfoList);
    }

    public List<Integer> compute(ISchemaComputation schemaComputation, List<Integer> indexOfTargetMeasurements) {
        PartialPath devicePath = schemaComputation.getDevicePath();
        String[] measurements = schemaComputation.getMeasurements();
        String[] nodes = devicePath.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            if (cur == null) {
                return indexOfTargetMeasurements;
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur == null) {
            return indexOfTargetMeasurements;
        }
        boolean firstNonViewMeasurement = true;
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        for (int index : indexOfTargetMeasurements) {
            SchemaNode node = cur.getChild(measurements[index]);
            if (node == null) {
                indexOfMissingMeasurements.add(index);
                continue;
            }
            if (firstNonViewMeasurement && !node.getAsMeasurementNode().isLogicalView()) {
                schemaComputation.computeDevice(cur.getAsEntityNode().isAligned());
                firstNonViewMeasurement = false;
            }
            schemaComputation.computeMeasurement(index, node.getAsMeasurementNode());
        }
        return indexOfMissingMeasurements;
    }

    public void computeSourceOfLogicalView(ISchemaComputation schemaComputation, List<Integer> indexOfTargetLogicalView) throws SemanticException {
        if (!schemaComputation.hasLogicalViewNeedProcess()) {
            return;
        }
        List<LogicalViewSchema> logicalViewSchemaList = schemaComputation.getLogicalViewSchemaList();
        for (Integer index : indexOfTargetLogicalView) {
            LogicalViewSchema logicalViewSchema = logicalViewSchemaList.get(index);
            PartialPath fullPath = logicalViewSchema.getSourcePathIfWritable();
            Pair<List<MeasurementPath>, Integer> searchResult = this.searchMeasurementPaths(fullPath);
            List measurementPathList = (List)searchResult.left;
            if (measurementPathList.isEmpty()) {
                throw new SemanticException((Throwable)((Object)new PathNotExistException(fullPath.getFullPath(), schemaComputation.getDevicePath().concatNode(logicalViewSchema.getMeasurementId()).getFullPath())));
            }
            if (measurementPathList.size() > 1) {
                throw new SemanticException(String.format("The source paths [%s] of view [%s] are multiple.", fullPath.getFullPath(), schemaComputation.getDevicePath().concatNode(logicalViewSchema.getMeasurementId())));
            }
            Integer realIndex = schemaComputation.getIndexListOfLogicalViewPaths().get(index);
            MeasurementPath measurementPath = (MeasurementPath)measurementPathList.get(0);
            schemaComputation.computeMeasurementOfView(realIndex, new MeasurementSchemaInfo(measurementPath.getMeasurement(), measurementPath.getMeasurementSchema(), null), measurementPath.isUnderAlignedEntity());
        }
    }

    public void appendMeasurementPaths(List<MeasurementPath> measurementPathList) {
        for (MeasurementPath measurementPath : measurementPathList) {
            this.appendSingleMeasurementPath(measurementPath);
        }
    }

    private void appendSingleMeasurementPath(MeasurementPath measurementPath) {
        this.appendSingleMeasurement((PartialPath)measurementPath, measurementPath.getMeasurementSchema(), measurementPath.getTagMap(), measurementPath.isMeasurementAliasExists() ? measurementPath.getMeasurementAlias() : null, measurementPath.isUnderAlignedEntity());
    }

    public void appendSingleMeasurement(PartialPath path, IMeasurementSchema schema, Map<String, String> tagMap, String alias, boolean isAligned) {
        String[] nodes = path.getNodes();
        SchemaNode cur = this.root;
        for (int i = 1; i < nodes.length; ++i) {
            SchemaEntityNode entityNode;
            SchemaNode child = cur.getChild(nodes[i]);
            if (child == null) {
                if (i == nodes.length - 1) {
                    SchemaMeasurementNode measurementNode = new SchemaMeasurementNode(nodes[i], schema);
                    if (alias != null) {
                        measurementNode.setAlias(alias);
                        cur.getAsEntityNode().addAliasChild(alias, measurementNode);
                    }
                    measurementNode.setTagMap(tagMap);
                    child = measurementNode;
                    if (schema.isLogicalView()) {
                        this.hasLogicalMeasurementPath = true;
                    }
                } else if (i == nodes.length - 2) {
                    entityNode = new SchemaEntityNode(nodes[i]);
                    entityNode.setAligned(isAligned);
                    child = entityNode;
                } else {
                    child = new SchemaInternalNode(nodes[i]);
                }
                cur.addChild(nodes[i], child);
            } else if (i == nodes.length - 2 && !child.isEntity()) {
                entityNode = new SchemaEntityNode(nodes[i]);
                cur.replaceChild(nodes[i], entityNode);
                if (!entityNode.isAligned()) {
                    entityNode.setAligned(isAligned);
                }
                child = entityNode;
            }
            cur = child;
        }
    }

    @Override
    public void mergeSchemaTree(ISchemaTree schemaTree) {
        if (schemaTree instanceof ClusterSchemaTree) {
            this.mergeSchemaTree((ClusterSchemaTree)schemaTree);
        }
    }

    public void mergeSchemaTree(ClusterSchemaTree schemaTree) {
        this.hasLogicalMeasurementPath = this.hasLogicalMeasurementPath || schemaTree.hasLogicalViewMeasurement();
        this.traverseAndMerge(this.root, null, schemaTree.root);
    }

    private void traverseAndMerge(SchemaNode thisNode, SchemaNode thisParent, SchemaNode thatNode) {
        for (SchemaNode thatChild : thatNode.getChildren().values()) {
            SchemaNode thisChild = thisNode.getChild(thatChild.getName());
            if (thisChild == null) {
                SchemaMeasurementNode measurementNode;
                SchemaEntityNode entityNode;
                thisNode.addChild(thatChild.getName(), thatChild);
                if (!thatChild.isMeasurement()) continue;
                if (thisNode.isEntity()) {
                    entityNode = thisNode.getAsEntityNode();
                } else {
                    entityNode = new SchemaEntityNode(thisNode.getName());
                    thisParent.replaceChild(thisNode.getName(), entityNode);
                    thisNode = entityNode;
                }
                if (!entityNode.isAligned()) {
                    entityNode.setAligned(thatNode.getAsEntityNode().isAligned());
                }
                if ((measurementNode = thatChild.getAsMeasurementNode()).getAlias() == null) continue;
                entityNode.addAliasChild(measurementNode.getAlias(), measurementNode);
                continue;
            }
            this.traverseAndMerge(thisChild, thisNode, thatChild);
        }
    }

    @Override
    public boolean hasLogicalViewMeasurement() {
        return this.hasLogicalMeasurementPath;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.root.serialize(outputStream);
    }

    public static ClusterSchemaTree deserialize(InputStream inputStream) throws IOException {
        ArrayDeque<SchemaNode> stack = new ArrayDeque<SchemaNode>();
        boolean hasLogicalView = false;
        while (inputStream.available() > 0) {
            byte nodeType = ReadWriteIOUtils.readByte((InputStream)inputStream);
            if (nodeType == 2) {
                SchemaMeasurementNode measurementNode = SchemaMeasurementNode.deserialize(inputStream);
                stack.push(measurementNode);
                if (!measurementNode.isLogicalView()) continue;
                hasLogicalView = true;
                continue;
            }
            SchemaInternalNode internalNode = nodeType == 1 ? SchemaEntityNode.deserialize(inputStream) : SchemaInternalNode.deserialize(inputStream);
            for (int childNum = ReadWriteIOUtils.readInt((InputStream)inputStream); childNum > 0; --childNum) {
                SchemaMeasurementNode measurementNode;
                SchemaNode child = (SchemaNode)stack.pop();
                internalNode.addChild(child.getName(), child);
                if (!child.isMeasurement() || (measurementNode = child.getAsMeasurementNode()).getAlias() == null) continue;
                internalNode.getAsEntityNode().addAliasChild(measurementNode.getAlias(), measurementNode);
            }
            stack.push(internalNode);
        }
        ClusterSchemaTree result = new ClusterSchemaTree((SchemaNode)stack.poll());
        result.hasLogicalMeasurementPath = hasLogicalView;
        return result;
    }

    @Override
    public String getBelongedDatabase(String pathName) {
        for (String database : this.databases) {
            if (!PathUtils.isStartWith((String)pathName, (String)database)) continue;
            return database;
        }
        throw new SemanticException("No matched database. Please check the path " + pathName);
    }

    @Override
    public String getBelongedDatabase(PartialPath path) {
        return this.getBelongedDatabase(path.getFullPath());
    }

    @Override
    public Set<String> getDatabases() {
        return this.databases;
    }

    @Override
    public void setDatabases(Set<String> databases) {
        this.databases = databases;
    }

    SchemaNode getRoot() {
        return this.root;
    }

    @Override
    public boolean isEmpty() {
        return this.root.getChildren() == null || this.root.getChildren().size() == 0;
    }
}

