/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.metric.PipeEventCounter;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlockingPendingQueue<E extends Event> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingPendingQueue.class);
    private static final long MAX_BLOCKING_TIME_MS = PipeConfig.getInstance().getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    protected final BlockingQueue<E> pendingQueue;
    private final PipeEventCounter eventCounter = new PipeEventCounter();

    protected BlockingPendingQueue(BlockingQueue<E> pendingQueue) {
        this.pendingQueue = pendingQueue;
    }

    public boolean waitedOffer(E event) {
        try {
            boolean offered = this.pendingQueue.offer(event, MAX_BLOCKING_TIME_MS, TimeUnit.MILLISECONDS);
            if (offered) {
                this.eventCounter.increaseEventCount((Event)event);
            }
            return offered;
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue offer is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean directOffer(E event) {
        boolean offered = this.pendingQueue.offer(event);
        if (offered) {
            this.eventCounter.increaseEventCount((Event)event);
        }
        return offered;
    }

    public boolean put(E event) {
        try {
            this.pendingQueue.put(event);
            this.eventCounter.increaseEventCount((Event)event);
            return true;
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue put is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public E directPoll() {
        Event event = (Event)this.pendingQueue.poll();
        this.eventCounter.decreaseEventCount(event);
        return (E)event;
    }

    public E waitedPoll() {
        Event event = null;
        try {
            event = (Event)this.pendingQueue.poll(MAX_BLOCKING_TIME_MS, TimeUnit.MILLISECONDS);
            this.eventCounter.decreaseEventCount(event);
        }
        catch (InterruptedException e) {
            LOGGER.info("pending queue poll is interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return (E)event;
    }

    public void clear() {
        this.pendingQueue.clear();
        this.eventCounter.reset();
    }

    public void forEach(Consumer<? super E> action) {
        this.pendingQueue.forEach(action);
    }

    public boolean isEmpty() {
        return this.pendingQueue.isEmpty();
    }

    public int size() {
        return this.pendingQueue.size();
    }

    public int getTabletInsertionEventCount() {
        return this.eventCounter.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.eventCounter.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.eventCounter.getPipeHeartbeatEventCount();
    }
}

