/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTransferBatchReqBuilder
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferBatchReqBuilder.class);
    protected final List<TPipeTransferReq> reqs = new ArrayList<TPipeTransferReq>();
    protected final List<Event> events = new ArrayList<Event>();
    protected final int maxDelayInMs;
    protected long firstEventProcessingTime = Long.MIN_VALUE;
    protected final PipeMemoryBlock allocatedMemoryBlock;
    protected long bufferSize = 0L;

    protected PipeTransferBatchReqBuilder(PipeParameters parameters) {
        this.maxDelayInMs = parameters.getIntOrDefault(Arrays.asList("connector.batch.max-delay-seconds", "sink.batch.max-delay-seconds"), 1) * 1000;
        long requestMaxBatchSizeInBytes = parameters.getLongOrDefault(Arrays.asList("connector.batch.size-bytes", "sink.batch.size-bytes"), 0x1000000L);
        this.allocatedMemoryBlock = PipeResourceManager.memory().tryAllocate(requestMaxBatchSizeInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 0L)).setShrinkCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has shrunk from {} to {}.", oldMemory, newMemory)).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, requestMaxBatchSizeInBytes)).setExpandCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has expanded from {} to {}.", oldMemory, newMemory));
        if (this.getMaxBatchSizeInBytes() != requestMaxBatchSizeInBytes) {
            LOGGER.info("PipeTransferBatchReqBuilder: the max batch size is adjusted from {} to {} due to the memory restriction", (Object)requestMaxBatchSizeInBytes, (Object)this.getMaxBatchSizeInBytes());
        }
    }

    public List<TPipeTransferReq> getTPipeTransferReqs() {
        return this.reqs;
    }

    protected long getMaxBatchSizeInBytes() {
        return this.allocatedMemoryBlock.getMemoryUsageInBytes();
    }

    public boolean isEmpty() {
        return this.reqs.isEmpty();
    }

    protected TPipeTransferReq buildTabletInsertionReq(TabletInsertionEvent event) throws IOException, WALPipeException {
        PipeTransferTabletRawReq req;
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
            req = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible() == null ? PipeTransferTabletBinaryReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer()) : PipeTransferTabletInsertNodeReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getInsertNode());
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event;
            req = PipeTransferTabletRawReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned());
        }
        return req;
    }

    @Override
    public void close() {
        this.allocatedMemoryBlock.close();
    }
}

