/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.client.async.AsyncConfigNodeHeartbeatClientPool;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeHeartbeatClientPool;
import org.apache.iotdb.confignode.client.async.handlers.heartbeat.ConfigNodeHeartbeatHandler;
import org.apache.iotdb.confignode.client.async.handlers.heartbeat.DataNodeHeartbeatHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.load.cache.LoadCache;
import org.apache.iotdb.confignode.manager.load.cache.node.ConfigNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatReq;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatService.class);
    private static final long HEARTBEAT_INTERVAL = ConfigNodeDescriptor.getInstance().getConf().getHeartbeatIntervalInMs();
    private final IManager configManager;
    private final LoadCache loadCache;
    private final Object heartbeatScheduleMonitor = new Object();
    private Future<?> currentHeartbeatFuture;
    private final ScheduledExecutorService heartBeatExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.CONFIG_NODE_HEART_BEAT_SERVICE.getName());
    private final AtomicLong heartbeatCounter = new AtomicLong(0L);

    public HeartbeatService(IManager configManager, LoadCache loadCache) {
        this.configManager = configManager;
        this.loadCache = loadCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHeartbeatService() {
        Object object = this.heartbeatScheduleMonitor;
        synchronized (object) {
            if (this.currentHeartbeatFuture == null) {
                this.currentHeartbeatFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.heartBeatExecutor, this::heartbeatLoopBody, (long)0L, (long)HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("Heartbeat service is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHeartbeatService() {
        Object object = this.heartbeatScheduleMonitor;
        synchronized (object) {
            if (this.currentHeartbeatFuture != null) {
                this.currentHeartbeatFuture.cancel(false);
                this.currentHeartbeatFuture = null;
                LOGGER.info("Heartbeat service is stopped successfully.");
            }
        }
    }

    private void heartbeatLoopBody() {
        Optional.ofNullable(this.getConsensusManager()).ifPresent(consensusManager -> {
            if (this.getConsensusManager().isLeader()) {
                this.pingRegisteredConfigNodes(this.genConfigNodeHeartbeatReq(), this.getNodeManager().getRegisteredConfigNodes());
                this.pingRegisteredDataNodes(this.genHeartbeatReq(), this.getNodeManager().getRegisteredDataNodes());
            }
        });
    }

    private TDataNodeHeartbeatReq genHeartbeatReq() {
        TDataNodeHeartbeatReq heartbeatReq = new TDataNodeHeartbeatReq();
        heartbeatReq.setHeartbeatTimestamp(System.currentTimeMillis());
        heartbeatReq.setNeedJudgeLeader(true);
        heartbeatReq.setNeedSamplingLoad(this.heartbeatCounter.get() % 10L == 0L);
        Pair<Long, Long> schemaQuotaRemain = this.configManager.getClusterSchemaManager().getSchemaQuotaRemain();
        heartbeatReq.setTimeSeriesQuotaRemain(((Long)schemaQuotaRemain.left).longValue());
        heartbeatReq.setDeviceQuotaRemain(((Long)schemaQuotaRemain.right).longValue());
        heartbeatReq.setNeedPipeMetaList(!PipeConfig.getInstance().isSeperatedPipeHeartbeatEnabled() && this.heartbeatCounter.get() % (long)PipeConfig.getInstance().getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() == 0L);
        if (!this.configManager.getClusterQuotaManager().hasSpaceQuotaLimit()) {
            heartbeatReq.setSchemaRegionIds(this.configManager.getClusterQuotaManager().getSchemaRegionIds());
            heartbeatReq.setDataRegionIds(this.configManager.getClusterQuotaManager().getDataRegionIds());
            heartbeatReq.setSpaceQuotaUsage(this.configManager.getClusterQuotaManager().getSpaceQuotaUsage());
        }
        this.heartbeatCounter.getAndIncrement();
        return heartbeatReq;
    }

    private TConfigNodeHeartbeatReq genConfigNodeHeartbeatReq() {
        TConfigNodeHeartbeatReq req = new TConfigNodeHeartbeatReq();
        req.setTimestamp(System.currentTimeMillis());
        return req;
    }

    private void pingRegisteredConfigNodes(TConfigNodeHeartbeatReq heartbeatReq, List<TConfigNodeLocation> registeredConfigNodes) {
        for (TConfigNodeLocation configNodeLocation : registeredConfigNodes) {
            if (configNodeLocation.getConfigNodeId() == ConfigNodeHeartbeatCache.CURRENT_NODE_ID) continue;
            ConfigNodeHeartbeatHandler handler = new ConfigNodeHeartbeatHandler(this.configManager, configNodeLocation.getConfigNodeId(), this.loadCache);
            AsyncConfigNodeHeartbeatClientPool.getInstance().getConfigNodeHeartBeat(configNodeLocation.getInternalEndPoint(), heartbeatReq, handler);
        }
    }

    private void pingRegisteredDataNodes(TDataNodeHeartbeatReq heartbeatReq, List<TDataNodeConfiguration> registeredDataNodes) {
        for (TDataNodeConfiguration dataNodeInfo : registeredDataNodes) {
            DataNodeHeartbeatHandler handler = new DataNodeHeartbeatHandler(dataNodeInfo.getLocation().getDataNodeId(), this.loadCache, this.configManager.getClusterQuotaManager().getDeviceNum(), this.configManager.getClusterQuotaManager().getTimeSeriesNum(), this.configManager.getClusterQuotaManager().getRegionDisk(), this.configManager.getClusterSchemaManager()::updateTimeSeriesUsage, this.configManager.getClusterSchemaManager()::updateDeviceUsage, this.configManager.getPipeManager().getPipeRuntimeCoordinator());
            this.configManager.getClusterQuotaManager().updateSpaceQuotaUsage();
            AsyncDataNodeHeartbeatClientPool.getInstance().getDataNodeHeartBeat(dataNodeInfo.getLocation().getInternalEndPoint(), heartbeatReq, handler);
        }
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }
}

