/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.procedure;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;

public class UpdateProcedurePlan
extends ConfigPhysicalPlan {
    private Procedure procedure;

    public Procedure getProcedure() {
        return this.procedure;
    }

    public void setProcedure(Procedure procedure) {
        this.procedure = procedure;
    }

    public UpdateProcedurePlan() {
        super(ConfigPhysicalPlanType.UpdateProcedure);
    }

    public UpdateProcedurePlan(Procedure procedure) {
        this();
        this.procedure = procedure;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        if (this.procedure != null) {
            this.procedure.serialize(stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.procedure = ProcedureFactory.getInstance().create(buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateProcedurePlan that = (UpdateProcedurePlan)o;
        return Objects.equals(this.procedure, that.procedure);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.procedure);
    }
}

