/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTsFileInput
implements TsFileInput {
    private static final Logger logger = LoggerFactory.getLogger(LocalTsFileInput.class);
    private final FileChannel channel;
    private final String filePath;

    public LocalTsFileInput(Path file) throws IOException {
        this.channel = FileChannel.open(file, StandardOpenOption.READ);
        this.filePath = file.toString();
    }

    @Override
    public long size() throws IOException {
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            logger.error("Error happened while getting {} size", (Object)this.filePath);
            throw e;
        }
    }

    @Override
    public long position() throws IOException {
        try {
            return this.channel.position();
        }
        catch (IOException e) {
            logger.error("Error happened while getting {} current position", (Object)this.filePath);
            throw e;
        }
    }

    @Override
    public TsFileInput position(long newPosition) throws IOException {
        try {
            this.channel.position(newPosition);
            return this;
        }
        catch (IOException e) {
            logger.error("Error happened while changing {} position to {}", (Object)this.filePath, (Object)newPosition);
            throw e;
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        try {
            return this.channel.read(dst);
        }
        catch (ClosedByInterruptException e) {
            logger.warn("Current thread is interrupted by another thread when it is blocked in an I/O operation upon a channel.");
            return -1;
        }
        catch (IOException e) {
            logger.error("Error happened while reading {} from current position", (Object)this.filePath);
            throw e;
        }
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        try {
            return this.channel.read(dst, position);
        }
        catch (ClosedByInterruptException e) {
            logger.warn("Current thread is interrupted by another thread when it is blocked in an I/O operation upon a channel.");
            return -1;
        }
        catch (IOException e) {
            logger.error("Error happened while reading {} from position {}", (Object)this.filePath, (Object)position);
            throw e;
        }
    }

    @Override
    public InputStream wrapAsInputStream() {
        return Channels.newInputStream(this.channel);
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            logger.error("Error happened while closing {}", (Object)this.filePath);
            throw e;
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }
}

