/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class TsBlock {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(TsBlock.class).instanceSize();
    private static final Column[] EMPTY_COLUMNS = new Column[0];
    private final TimeColumn timeColumn;
    private final Column[] valueColumns;
    private final int positionCount;
    private volatile long retainedSizeInBytes = -1L;

    public static TsBlock wrapBlocksWithoutCopy(int positionCount, TimeColumn timeColumn, Column[] valueColumns) {
        return new TsBlock(false, positionCount, timeColumn, valueColumns);
    }

    public TsBlock(int positionCount) {
        this(false, positionCount, null, EMPTY_COLUMNS);
    }

    public TsBlock(TimeColumn timeColumn, Column ... valueColumns) {
        this(true, TsBlock.determinePositionCount(valueColumns), timeColumn, valueColumns);
    }

    public TsBlock(int positionCount, TimeColumn timeColumn, Column ... valueColumns) {
        this(true, positionCount, timeColumn, valueColumns);
    }

    private TsBlock(boolean columnsCopyRequired, int positionCount, TimeColumn timeColumn, Column[] valueColumns) {
        Objects.requireNonNull(valueColumns, "blocks is null");
        this.positionCount = positionCount;
        this.timeColumn = timeColumn;
        if (valueColumns.length == 0) {
            this.valueColumns = EMPTY_COLUMNS;
            this.retainedSizeInBytes = INSTANCE_SIZE;
        } else {
            this.valueColumns = columnsCopyRequired ? (Column[])valueColumns.clone() : valueColumns;
        }
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getStartTime() {
        return this.timeColumn.getStartTime();
    }

    public long getEndTime() {
        return this.timeColumn.getEndTime();
    }

    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    public long getRetainedSizeInBytes() {
        if (this.retainedSizeInBytes < 0L) {
            return this.updateRetainedSize();
        }
        return this.retainedSizeInBytes;
    }

    public TsBlock getRegion(int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > this.positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position %s and length %s in page with %s positions", positionOffset, length, this.positionCount));
        }
        int channelCount = this.getValueColumnCount();
        Column[] slicedColumns = new Column[channelCount];
        for (int i = 0; i < channelCount; ++i) {
            slicedColumns[i] = this.valueColumns[i].getRegion(positionOffset, length);
        }
        return TsBlock.wrapBlocksWithoutCopy(length, (TimeColumn)this.timeColumn.getRegion(positionOffset, length), slicedColumns);
    }

    public TsBlock appendValueColumns(Column[] columns) {
        Column[] newBlocks = Arrays.copyOf(this.valueColumns, this.valueColumns.length + columns.length);
        int newColumnIndex = this.valueColumns.length;
        for (Column column : columns) {
            Objects.requireNonNull(column, "Column is null");
            if (this.positionCount != column.getPositionCount()) {
                throw new IllegalArgumentException("Block does not have same position count");
            }
            newBlocks[newColumnIndex++] = column;
        }
        return TsBlock.wrapBlocksWithoutCopy(this.positionCount, this.timeColumn, newBlocks);
    }

    public TsBlock insertValueColumn(int index, Column column) {
        Objects.requireNonNull(column, "Column is null");
        if (this.positionCount != column.getPositionCount()) {
            throw new IllegalArgumentException("Block does not have same position count");
        }
        Column[] newBlocks = Arrays.copyOf(this.valueColumns, this.valueColumns.length + 1);
        System.arraycopy(newBlocks, index, newBlocks, index + 1, this.valueColumns.length - index);
        newBlocks[index] = column;
        return TsBlock.wrapBlocksWithoutCopy(this.positionCount, this.timeColumn, newBlocks);
    }

    public TsBlock subTsBlock(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("FromIndex of subTsBlock cannot over positionCount.");
        }
        TimeColumn subTimeColumn = (TimeColumn)this.timeColumn.subColumn(fromIndex);
        Column[] subValueColumns = new Column[this.valueColumns.length];
        for (int i = 0; i < subValueColumns.length; ++i) {
            subValueColumns[i] = this.valueColumns[i].subColumn(fromIndex);
        }
        return new TsBlock(subTimeColumn, subValueColumns);
    }

    public TsBlock skipFirst() {
        return this.subTsBlock(1);
    }

    public long getTimeByIndex(int index) {
        return this.timeColumn.getLong(index);
    }

    public int getValueColumnCount() {
        return this.valueColumns.length;
    }

    public TimeColumn getTimeColumn() {
        return this.timeColumn;
    }

    public Column[] getValueColumns() {
        return this.valueColumns;
    }

    public Column getColumn(int columnIndex) {
        return this.valueColumns[columnIndex];
    }

    public Column[] getTimeAndValueColumn(int columnIndex) {
        Column[] columns = new Column[]{this.getTimeColumn(), this.getColumn(columnIndex)};
        return columns;
    }

    public Column[] getColumns(int[] columnIndexes) {
        Column[] columns = new Column[columnIndexes.length];
        for (int i = 0; i < columnIndexes.length; ++i) {
            columns[i] = this.valueColumns[columnIndexes[i]];
        }
        return columns;
    }

    public TsBlockSingleColumnIterator getTsBlockSingleColumnIterator() {
        return new TsBlockSingleColumnIterator(0);
    }

    public TsBlockSingleColumnIterator getTsBlockSingleColumnIterator(int columnIndex) {
        return new TsBlockSingleColumnIterator(0, columnIndex);
    }

    public void reverse() {
        this.timeColumn.reverse();
        for (Column valueColumn : this.valueColumns) {
            valueColumn.reverse();
        }
    }

    public TsBlockRowIterator getTsBlockRowIterator() {
        return new TsBlockRowIterator(0);
    }

    public TsBlockAlignedRowIterator getTsBlockAlignedRowIterator() {
        return new TsBlockAlignedRowIterator(0);
    }

    private long updateRetainedSize() {
        long newRetainedSizeInBytes = INSTANCE_SIZE;
        newRetainedSizeInBytes += this.timeColumn.getRetainedSizeInBytes();
        for (Column column : this.valueColumns) {
            newRetainedSizeInBytes += column.getRetainedSizeInBytes();
        }
        this.retainedSizeInBytes = newRetainedSizeInBytes;
        return newRetainedSizeInBytes;
    }

    public int getTotalInstanceSize() {
        int totalInstanceSize = INSTANCE_SIZE;
        totalInstanceSize += this.timeColumn.getInstanceSize();
        for (Column column : this.valueColumns) {
            totalInstanceSize += column.getInstanceSize();
        }
        return totalInstanceSize;
    }

    private static int determinePositionCount(Column ... columns) {
        Objects.requireNonNull(columns, "columns is null");
        if (columns.length == 0) {
            throw new IllegalArgumentException("columns is empty");
        }
        return columns[0].getPositionCount();
    }

    public void update(int updateIdx, TsBlock sourceTsBlock, int sourceIndex) {
        this.timeColumn.getTimes()[updateIdx] = sourceTsBlock.getTimeByIndex(sourceIndex);
        block8: for (int i = 0; i < this.getValueColumnCount(); ++i) {
            if (sourceTsBlock.getValueColumns()[i].isNull(sourceIndex)) {
                this.valueColumns[i].isNull()[updateIdx] = true;
                continue;
            }
            switch (this.valueColumns[i].getDataType()) {
                case BOOLEAN: {
                    this.valueColumns[i].isNull()[updateIdx] = false;
                    this.valueColumns[i].getBooleans()[updateIdx] = sourceTsBlock.getValueColumns()[i].getBoolean(sourceIndex);
                    continue block8;
                }
                case INT32: {
                    this.valueColumns[i].isNull()[updateIdx] = false;
                    this.valueColumns[i].getInts()[updateIdx] = sourceTsBlock.getValueColumns()[i].getInt(sourceIndex);
                    continue block8;
                }
                case INT64: {
                    this.valueColumns[i].isNull()[updateIdx] = false;
                    this.valueColumns[i].getLongs()[updateIdx] = sourceTsBlock.getValueColumns()[i].getLong(sourceIndex);
                    continue block8;
                }
                case FLOAT: {
                    this.valueColumns[i].isNull()[updateIdx] = false;
                    this.valueColumns[i].getFloats()[updateIdx] = sourceTsBlock.getValueColumns()[i].getFloat(sourceIndex);
                    continue block8;
                }
                case DOUBLE: {
                    this.valueColumns[i].isNull()[updateIdx] = false;
                    this.valueColumns[i].getDoubles()[updateIdx] = sourceTsBlock.getValueColumns()[i].getDouble(sourceIndex);
                    continue block8;
                }
                case TEXT: {
                    this.valueColumns[i].isNull()[updateIdx] = false;
                    this.valueColumns[i].getBinaries()[updateIdx] = sourceTsBlock.getValueColumns()[i].getBinary(sourceIndex);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException("Unknown datatype: " + this.valueColumns[i].getDataType());
                }
            }
        }
    }

    private class TsBlockAlignedRowIterator
    implements IPointReader,
    IBatchDataIterator {
        private int rowIndex;

        public TsBlockAlignedRowIterator(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < TsBlock.this.positionCount;
        }

        @Override
        public boolean hasNext(long minBound, long maxBound) {
            while (this.hasNext() && this.currentTime() >= minBound && this.currentTime() < maxBound) {
                this.next();
            }
            return this.hasNext();
        }

        @Override
        public void next() {
            ++this.rowIndex;
        }

        @Override
        public long currentTime() {
            return TsBlock.this.timeColumn.getLong(this.rowIndex);
        }

        public TsPrimitiveType[] currentValue() {
            TsPrimitiveType[] tsPrimitiveTypes = new TsPrimitiveType[TsBlock.this.valueColumns.length];
            for (int i = 0; i < TsBlock.this.valueColumns.length; ++i) {
                if (TsBlock.this.valueColumns[i].isNull(this.rowIndex)) continue;
                tsPrimitiveTypes[i] = TsBlock.this.valueColumns[i].getTsPrimitiveType(this.rowIndex);
            }
            return tsPrimitiveTypes;
        }

        @Override
        public void reset() {
            this.rowIndex = 0;
        }

        @Override
        public int totalLength() {
            return TsBlock.this.positionCount;
        }

        @Override
        public boolean hasNextTimeValuePair() {
            while (this.hasNext() && this.isCurrentValueAllNull()) {
                this.next();
            }
            return this.hasNext();
        }

        @Override
        public TimeValuePair nextTimeValuePair() {
            TimeValuePair res = this.currentTimeValuePair();
            this.next();
            return res;
        }

        @Override
        public TimeValuePair currentTimeValuePair() {
            return new TimeValuePair(TsBlock.this.timeColumn.getLong(this.rowIndex), (TsPrimitiveType)new TsPrimitiveType.TsVector(this.currentValue()));
        }

        @Override
        public void close() {
        }

        public long getEndTime() {
            return TsBlock.this.getEndTime();
        }

        public long getStartTime() {
            return TsBlock.this.getStartTime();
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        private boolean isCurrentValueAllNull() {
            for (Column valueColumn : TsBlock.this.valueColumns) {
                if (valueColumn.isNull(this.rowIndex)) continue;
                return false;
            }
            return true;
        }
    }

    public class TsBlockRowIterator
    implements Iterator<Object[]> {
        protected int rowIndex;
        protected int columnCount;

        public TsBlockRowIterator(int rowIndex) {
            this.rowIndex = rowIndex;
            this.columnCount = TsBlock.this.getValueColumnCount();
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < TsBlock.this.positionCount;
        }

        @Override
        public Object[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int curColumnCount = TsBlock.this.getValueColumnCount();
            Object[] row = new Object[curColumnCount + 1];
            for (int i = 0; i < curColumnCount; ++i) {
                Column column = TsBlock.this.valueColumns[i];
                row[i] = column.isNull(this.rowIndex) ? null : column.getObject(this.rowIndex);
            }
            row[curColumnCount] = TsBlock.this.timeColumn.getObject(this.rowIndex);
            ++this.rowIndex;
            return row;
        }
    }

    public class TsBlockSingleColumnIterator
    implements IPointReader,
    IBatchDataIterator {
        private int rowIndex;
        private final int columnIndex;

        public TsBlockSingleColumnIterator(int rowIndex) {
            this.rowIndex = rowIndex;
            this.columnIndex = 0;
        }

        public TsBlockSingleColumnIterator(int rowIndex, int columnIndex) {
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < TsBlock.this.positionCount;
        }

        @Override
        public boolean hasNext(long minBound, long maxBound) {
            return this.hasNext();
        }

        @Override
        public void next() {
            ++this.rowIndex;
        }

        @Override
        public long currentTime() {
            return TsBlock.this.timeColumn.getLong(this.rowIndex);
        }

        @Override
        public Object currentValue() {
            return TsBlock.this.valueColumns[this.columnIndex].getTsPrimitiveType(this.rowIndex).getValue();
        }

        @Override
        public void reset() {
            this.rowIndex = 0;
        }

        @Override
        public int totalLength() {
            return TsBlock.this.positionCount;
        }

        @Override
        public boolean hasNextTimeValuePair() {
            return this.hasNext();
        }

        @Override
        public TimeValuePair nextTimeValuePair() {
            TimeValuePair res = this.currentTimeValuePair();
            this.next();
            return res;
        }

        @Override
        public TimeValuePair currentTimeValuePair() {
            return new TimeValuePair(TsBlock.this.timeColumn.getLong(this.rowIndex), TsBlock.this.valueColumns[this.columnIndex].getTsPrimitiveType(this.rowIndex));
        }

        @Override
        public void close() {
        }

        public long getEndTime() {
            return TsBlock.this.getEndTime();
        }

        public long getStartTime() {
            return TsBlock.this.getStartTime();
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }
    }
}

