/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.string;

import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFRegexSplit
implements UDTF {
    private String regex;
    private int index;

    @Override
    public void beforeStart(UDFParameters udfParameters, UDTFConfigurations udtfConfigurations) throws Exception {
        this.regex = udfParameters.getString("regex");
        this.index = udfParameters.getIntOrDefault("index", -1);
        udtfConfigurations.setAccessStrategy(new RowByRowAccessStrategy());
        if (this.index == -1) {
            udtfConfigurations.setOutputDataType(Type.INT32);
        } else {
            udtfConfigurations.setOutputDataType(Type.TEXT);
        }
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        String[] splitResult = row.getString(0).split(this.regex);
        if (this.index == -1) {
            collector.putInt(row.getTime(), splitResult.length);
        } else if (this.index < splitResult.length) {
            collector.putString(row.getTime(), splitResult[this.index]);
        }
    }

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.TEXT).validate(regex -> ((String)regex).length() > 0, "regexp has to be a valid regular expression.", (Object)validator.getParameters().getStringOrDefault("regex", "")).validate(index -> (Integer)index >= -1, "index must a non-negative integer to fetch split results or -1 to get length.", (Object)validator.getParameters().getIntOrDefault("index", -1));
    }
}

