/*
 * Decompiled with CFR 0.152.
 */
package com.github.ggalmazor.ltdownsampling.tools;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class SlidingCollector<T>
implements Collector<T, List<List<T>>, List<List<T>>> {
    private final int size;
    private final int step;
    private final int window;
    private final Queue<T> buffer = new ArrayDeque<T>();
    private int totalIn = 0;

    public SlidingCollector(int size, int step) {
        this.size = size;
        this.step = step;
        this.window = Integer.max(size, step);
    }

    @Override
    public Supplier<List<List<T>>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<List<T>>, T> accumulator() {
        return (lists, t2) -> {
            this.buffer.offer(t2);
            ++this.totalIn;
            if (this.buffer.size() == this.window) {
                this.dumpCurrent((List<List<T>>)lists);
                this.shiftBy(this.step);
            }
        };
    }

    @Override
    public Function<List<List<T>>, List<List<T>>> finisher() {
        return lists -> {
            int totalOut;
            if (!this.buffer.isEmpty() && (totalOut = this.estimateTotalOut()) > lists.size()) {
                this.dumpCurrent((List<List<T>>)lists);
            }
            return lists;
        };
    }

    private int estimateTotalOut() {
        return Integer.max(0, (this.totalIn + this.step - this.size - 1) / this.step) + 1;
    }

    private void dumpCurrent(List<List<T>> lists) {
        List batch = this.buffer.stream().limit(this.size).collect(Collectors.toList());
        lists.add(batch);
    }

    private void shiftBy(int by) {
        for (int i = 0; i < by; ++i) {
            this.buffer.remove();
        }
    }

    @Override
    public BinaryOperator<List<List<T>>> combiner() {
        return (l1, l2) -> {
            throw new UnsupportedOperationException("Combining not possible");
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.noneOf(Collector.Characteristics.class);
    }
}

