/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.NameResolverProvider;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class UdpResources
implements LoopResources {
    final LoopResources defaultLoops;
    final AtomicReference<AddressResolverGroup<?>> defaultResolver;
    static final int DEFAULT_UDP_THREAD_COUNT = Integer.parseInt(System.getProperty("reactor.netty.udp.ioThreadCount", "" + Schedulers.DEFAULT_POOL_SIZE));
    static final NameResolverProvider DEFAULT_NAME_RESOLVER_PROVIDER;
    static final Logger log;
    static final Function<LoopResources, UdpResources> ON_UDP_NEW;
    static final AtomicReference<UdpResources> udpResources;

    public static UdpResources get() {
        return UdpResources.getOrCreate(null, ON_UDP_NEW, "udp");
    }

    public static UdpResources reset() {
        UdpResources.shutdown();
        return UdpResources.getOrCreate(null, ON_UDP_NEW, "udp");
    }

    public static UdpResources set(LoopResources loops) {
        return UdpResources.getOrCreate(loops, ON_UDP_NEW, "udp");
    }

    public static void shutdown() {
        UdpResources resources = udpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> shutdownLater() {
        return UdpResources.shutdownLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> shutdownLater(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        return Mono.defer(() -> {
            UdpResources resources = udpResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater(quietPeriod, timeout);
            }
            return Mono.empty();
        });
    }

    protected UdpResources(LoopResources defaultLoops) {
        this.defaultLoops = defaultLoops;
        this.defaultResolver = new AtomicReference();
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    @Override
    public Mono<Void> disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.empty();
    }

    @Override
    public boolean isDisposed() {
        return this.defaultLoops.isDisposed();
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL onChannel(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return this.defaultLoops.onChannel(channelType, group);
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> onChannelClass(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return this.defaultLoops.onChannelClass(channelType, group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    protected void _dispose() {
        this._disposeResolver();
        this.defaultLoops.dispose();
    }

    protected Mono<Void> _disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.when(this._disposeResolverLater(), this.defaultLoops.disposeLater(quietPeriod, timeout));
    }

    AddressResolverGroup<?> getOrCreateDefaultResolver() {
        AddressResolverGroup<?> resolverGroup = this.defaultResolver.get();
        if (resolverGroup == null) {
            DnsAddressResolverGroup newResolverGroup = DEFAULT_NAME_RESOLVER_PROVIDER.newNameResolverGroup(this.defaultLoops, LoopResources.DEFAULT_NATIVE);
            if (!this.defaultResolver.compareAndSet(null, newResolverGroup)) {
                newResolverGroup.close();
            }
            resolverGroup = this.getOrCreateDefaultResolver();
        }
        return resolverGroup;
    }

    void _disposeResolver() {
        AddressResolverGroup<?> addressResolverGroup = this.defaultResolver.get();
        if (addressResolverGroup != null) {
            addressResolverGroup.close();
        }
    }

    Mono<Void> _disposeResolverLater() {
        Mono<Void> disposeResolver = Mono.empty();
        AddressResolverGroup<?> addressResolverGroup = this.defaultResolver.get();
        if (addressResolverGroup != null) {
            disposeResolver = Mono.fromRunnable(addressResolverGroup::close);
        }
        return disposeResolver;
    }

    protected static UdpResources getOrCreate(@Nullable LoopResources loops, Function<LoopResources, UdpResources> onNew, String name) {
        UdpResources resources;
        while ((resources = udpResources.get()) == null || loops != null) {
            UdpResources update = UdpResources.create(resources, loops, name, onNew);
            if (udpResources.compareAndSet(resources, update)) {
                if (resources != null) {
                    if (log.isWarnEnabled()) {
                        log.warn("[{}] resources will use a new LoopResources: {},the previous LoopResources will be disposed", name, loops);
                    }
                    resources._disposeResolver();
                    resources.defaultLoops.dispose();
                } else {
                    String loopType;
                    String string = loopType = loops == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} LoopResources: {}", name, loopType, update.defaultLoops);
                    }
                }
                return update;
            }
            update._dispose();
        }
        return resources;
    }

    static <T extends UdpResources> T create(@Nullable T previous, @Nullable LoopResources loops, String name, Function<LoopResources, T> onNew) {
        loops = previous == null ? (loops == null ? LoopResources.create(name, DEFAULT_UDP_THREAD_COUNT, true) : loops) : (loops == null ? previous.defaultLoops : loops);
        return (T)((UdpResources)onNew.apply(loops));
    }

    static {
        log = Loggers.getLogger(UdpResources.class);
        DEFAULT_NAME_RESOLVER_PROVIDER = NameResolverProvider.builder().build();
        ON_UDP_NEW = UdpResources::new;
        udpResources = new AtomicReference();
    }
}

