/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.AsyncMapping;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import reactor.core.Exceptions;
import reactor.netty.ReactorNetty;
import reactor.netty.tcp.SniProvider;
import reactor.netty.tcp.TcpClientSecure;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public final class SslProvider {
    final SslContext sslContext;
    final SslContextBuilder sslContextBuilder;
    final DefaultConfigurationType type;
    final long handshakeTimeoutMillis;
    final long closeNotifyFlushTimeoutMillis;
    final long closeNotifyReadTimeoutMillis;
    final Consumer<? super SslHandler> handlerConfigurator;
    final int builderHashCode;
    final SniProvider sniProvider;
    final Map<String, SslProvider> confPerDomainName;
    final AsyncMapping<String, SslProvider> sniMappings;
    static final Logger log = Loggers.getLogger(SslProvider.class);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler("reactor.netty.tcp.ssl", LogLevel.DEBUG, Charset.defaultCharset());
    static final List<String> HTTP2_CIPHERS = Collections.unmodifiableList(Arrays.asList("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"));

    public static SslContextSpec builder() {
        return new Build();
    }

    public static SslProvider addHandlerConfigurator(SslProvider provider, Consumer<? super SslHandler> handlerConfigurator) {
        Objects.requireNonNull(provider, "provider");
        Objects.requireNonNull(handlerConfigurator, "handlerConfigurator");
        return new SslProvider(provider, handlerConfigurator);
    }

    @Deprecated
    public static SslProvider updateDefaultConfiguration(SslProvider provider, DefaultConfigurationType type) {
        Objects.requireNonNull(provider, "provider");
        Objects.requireNonNull(type, "type");
        return new SslProvider(provider, type);
    }

    public static SslProvider defaultClientProvider() {
        return TcpClientSecure.DEFAULT_SSL_PROVIDER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SslProvider(Build builder) {
        this.sslContextBuilder = builder.sslCtxBuilder;
        this.type = builder.type;
        if (builder.sslContext == null) {
            if (this.sslContextBuilder != null) {
                if (this.type != null) {
                    this.updateDefaultConfiguration();
                }
                try {
                    this.sslContext = this.sslContextBuilder.build();
                }
                catch (SSLException e) {
                    throw Exceptions.propagate(e);
                }
            } else {
                if (builder.protocolSslContextSpec == null) throw new IllegalArgumentException("Neither SslContextBuilder nor SslContext is specified");
                try {
                    this.sslContext = builder.protocolSslContextSpec.sslContext();
                }
                catch (SSLException e) {
                    throw Exceptions.propagate(e);
                }
            }
        } else {
            this.sslContext = builder.sslContext;
        }
        if (builder.serverNames != null) {
            Consumer<SslHandler> configurator = h2 -> {
                SSLEngine engine = h2.engine();
                SSLParameters sslParameters = engine.getSSLParameters();
                sslParameters.setServerNames(builder.serverNames);
                engine.setSSLParameters(sslParameters);
            };
            this.handlerConfigurator = builder.handlerConfigurator == null ? configurator : configurator.andThen(builder.handlerConfigurator);
        } else {
            this.handlerConfigurator = builder.handlerConfigurator;
        }
        this.handshakeTimeoutMillis = builder.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = builder.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = builder.closeNotifyReadTimeoutMillis;
        this.builderHashCode = builder.hashCode();
        this.confPerDomainName = builder.confPerDomainName;
        this.sniMappings = builder.sniMappings;
        this.sniProvider = !this.confPerDomainName.isEmpty() ? (this.type != null ? this.updateAllSslProviderConfiguration(this.confPerDomainName, this, this.type) : new SniProvider(this.confPerDomainName, this)) : (this.sniMappings != null ? new SniProvider(this.sniMappings) : null);
    }

    SslProvider(SslProvider from, Consumer<? super SslHandler> handlerConfigurator) {
        this.sslContext = from.sslContext;
        this.sslContextBuilder = from.sslContextBuilder;
        this.type = from.type;
        this.handlerConfigurator = from.handlerConfigurator == null ? handlerConfigurator : h2 -> {
            handlerConfigurator.accept((SslHandler)h2);
            from.handlerConfigurator.accept((SslHandler)h2);
        };
        this.handshakeTimeoutMillis = from.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = from.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = from.closeNotifyReadTimeoutMillis;
        this.builderHashCode = from.builderHashCode;
        this.confPerDomainName = from.confPerDomainName;
        this.sniMappings = from.sniMappings;
        this.sniProvider = from.sniProvider;
    }

    SslProvider(SslProvider from, DefaultConfigurationType type) {
        this.sslContextBuilder = from.sslContextBuilder;
        this.type = type;
        if (this.sslContextBuilder != null) {
            this.updateDefaultConfiguration();
            try {
                this.sslContext = this.sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw Exceptions.propagate(e);
            }
        } else {
            this.sslContext = from.sslContext;
        }
        this.handlerConfigurator = from.handlerConfigurator;
        this.handshakeTimeoutMillis = from.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = from.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = from.closeNotifyReadTimeoutMillis;
        this.builderHashCode = from.builderHashCode;
        this.confPerDomainName = from.confPerDomainName;
        this.sniMappings = from.sniMappings;
        this.sniProvider = from.sniProvider != null ? (!this.confPerDomainName.isEmpty() ? this.updateAllSslProviderConfiguration(this.confPerDomainName, this, type) : new SniProvider(this.sniMappings)) : null;
    }

    SniProvider updateAllSslProviderConfiguration(Map<String, SslProvider> confPerDomainName, SslProvider defaultSslProvider, DefaultConfigurationType type) {
        HashMap<String, SslProvider> config = new HashMap<String, SslProvider>();
        confPerDomainName.forEach((s2, sslProvider) -> config.put((String)s2, SslProvider.updateDefaultConfiguration(sslProvider, type)));
        return new SniProvider(config, defaultSslProvider);
    }

    void updateDefaultConfiguration() {
        switch (this.type) {
            case H2: {
                this.sslContextBuilder.sslProvider(io.netty.handler.ssl.SslProvider.isAlpnSupported(io.netty.handler.ssl.SslProvider.OPENSSL) ? io.netty.handler.ssl.SslProvider.OPENSSL : io.netty.handler.ssl.SslProvider.JDK).ciphers(HTTP2_CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2", "http/1.1"));
                break;
            }
            case TCP: {
                this.sslContextBuilder.sslProvider(OpenSsl.isAvailable() ? io.netty.handler.ssl.SslProvider.OPENSSL : io.netty.handler.ssl.SslProvider.JDK).ciphers(null, IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(null);
                break;
            }
        }
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    @Nullable
    public DefaultConfigurationType getDefaultConfigurationType() {
        return this.type;
    }

    public void configure(SslHandler sslHandler) {
        Objects.requireNonNull(sslHandler, "sslHandler");
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        sslHandler.setCloseNotifyFlushTimeoutMillis(this.closeNotifyFlushTimeoutMillis);
        sslHandler.setCloseNotifyReadTimeoutMillis(this.closeNotifyReadTimeoutMillis);
        if (this.handlerConfigurator != null) {
            this.handlerConfigurator.accept(sslHandler);
        }
    }

    public void addSslHandler(Channel channel, @Nullable SocketAddress remoteAddress, boolean sslDebug) {
        SslHandler sslHandler;
        Objects.requireNonNull(channel, "channel");
        if (this.sniProvider != null) {
            this.sniProvider.addSniHandler(channel, sslDebug);
            return;
        }
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress sniInfo = (InetSocketAddress)remoteAddress;
            sslHandler = this.getSslContext().newHandler(channel.alloc(), sniInfo.getHostString(), sniInfo.getPort());
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "SSL enabled using engine {} and SNI {}"), sslHandler.engine(), sniInfo);
            }
        } else {
            sslHandler = this.getSslContext().newHandler(channel.alloc());
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "SSL enabled using engine {}"), sslHandler.engine());
            }
        }
        this.configure(sslHandler);
        ChannelPipeline pipeline = channel.pipeline();
        if (pipeline.get("reactor.left.proxyHandler") != null) {
            pipeline.addAfter("reactor.left.proxyHandler", "reactor.left.sslHandler", sslHandler);
        } else if (pipeline.get("reactor.left.nonSslRedirectDetector") != null) {
            pipeline.addAfter("reactor.left.nonSslRedirectDetector", "reactor.left.sslHandler", sslHandler);
        } else {
            pipeline.addFirst("reactor.left.sslHandler", (ChannelHandler)sslHandler);
        }
        SslProvider.addSslReadHandler(pipeline, sslDebug);
    }

    public String toString() {
        return "SslProvider {type=" + (Object)((Object)this.type) + ", handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", closeNotifyFlushTimeoutMillis=" + this.closeNotifyFlushTimeoutMillis + ", closeNotifyReadTimeoutMillis=" + this.closeNotifyReadTimeoutMillis + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslProvider that = (SslProvider)o;
        return this.builderHashCode == that.builderHashCode;
    }

    public int hashCode() {
        return Objects.hash(this.builderHashCode);
    }

    static void addSslReadHandler(ChannelPipeline pipeline, boolean sslDebug) {
        if (pipeline.get("reactor.left.loggingHandler") != null) {
            pipeline.addAfter("reactor.left.loggingHandler", "reactor.left.sslReader", new SslReadHandler());
            if (sslDebug) {
                pipeline.addBefore("reactor.left.sslHandler", "reactor.left.sslLoggingHandler", LOGGING_HANDLER);
            }
        } else {
            pipeline.addAfter("reactor.left.sslHandler", "reactor.left.sslReader", new SslReadHandler());
        }
    }

    static final class SslReadHandler
    extends ChannelInboundHandlerAdapter {
        boolean handshakeDone;

        SslReadHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            if (!this.handshakeDone) {
                ctx.read();
            }
            ctx.fireChannelReadComplete();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshake2;
                this.handshakeDone = true;
                if (ctx.pipeline().context(this) != null) {
                    ctx.pipeline().remove(this);
                }
                if ((handshake2 = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                    ctx.fireChannelActive();
                } else {
                    ctx.fireExceptionCaught(handshake2.cause());
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    static final class Build
    implements SslContextSpec,
    DefaultConfigurationSpec,
    Builder {
        static final long DEFAULT_SSL_HANDSHAKE_TIMEOUT = Long.parseLong(System.getProperty("reactor.netty.tcp.sslHandshakeTimeout", "10000"));
        SslContextBuilder sslCtxBuilder;
        ProtocolSslContextSpec protocolSslContextSpec;
        DefaultConfigurationType type;
        SslContext sslContext;
        Consumer<? super SslHandler> handlerConfigurator;
        long handshakeTimeoutMillis = DEFAULT_SSL_HANDSHAKE_TIMEOUT;
        long closeNotifyFlushTimeoutMillis = 3000L;
        long closeNotifyReadTimeoutMillis;
        List<SNIServerName> serverNames;
        final Map<String, SslProvider> confPerDomainName = new HashMap<String, SslProvider>();
        AsyncMapping<String, SslProvider> sniMappings;

        Build() {
        }

        @Override
        public Builder sslContext(ProtocolSslContextSpec protocolSslContextSpec) {
            this.protocolSslContextSpec = protocolSslContextSpec;
            this.type = DefaultConfigurationType.NONE;
            return this;
        }

        @Override
        public final Builder sslContext(SslContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            this.type = DefaultConfigurationType.NONE;
            return this;
        }

        @Override
        public final DefaultConfigurationSpec sslContext(SslContextBuilder sslCtxBuilder) {
            this.sslCtxBuilder = Objects.requireNonNull(sslCtxBuilder, "sslCtxBuilder");
            return this;
        }

        @Override
        public final Builder defaultConfiguration(DefaultConfigurationType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public final Builder handshakeTimeout(Duration handshakeTimeout) {
            Objects.requireNonNull(handshakeTimeout, "handshakeTimeout");
            return this.handshakeTimeoutMillis(handshakeTimeout.toMillis());
        }

        @Override
        public final Builder handlerConfigurator(Consumer<? super SslHandler> handlerConfigurator) {
            Objects.requireNonNull(handlerConfigurator, "handshakeTimeout");
            this.handlerConfigurator = handlerConfigurator;
            return this;
        }

        @Override
        public final Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            if (handshakeTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl handshake timeout must be positive was: " + handshakeTimeoutMillis);
            }
            this.handshakeTimeoutMillis = handshakeTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            Objects.requireNonNull(closeNotifyFlushTimeout, "closeNotifyFlushTimeout");
            return this.closeNotifyFlushTimeoutMillis(closeNotifyFlushTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyFlushTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
            if (closeNotifyFlushTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify flush timeout must be positive, was: " + closeNotifyFlushTimeoutMillis);
            }
            this.closeNotifyFlushTimeoutMillis = closeNotifyFlushTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            Objects.requireNonNull(closeNotifyReadTimeout, "closeNotifyReadTimeout");
            return this.closeNotifyReadTimeoutMillis(closeNotifyReadTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyReadTimeoutMillis(long closeNotifyReadTimeoutMillis) {
            if (closeNotifyReadTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify read timeout must be positive, was: " + closeNotifyReadTimeoutMillis);
            }
            this.closeNotifyReadTimeoutMillis = closeNotifyReadTimeoutMillis;
            return this;
        }

        @Override
        public Builder addSniMapping(String domainName, Consumer<? super SslContextSpec> sslProviderBuilder) {
            this.addInternal(domainName, sslProviderBuilder);
            this.sniMappings = null;
            return this;
        }

        @Override
        public Builder addSniMappings(Map<String, Consumer<? super SslContextSpec>> confPerDomainName) {
            Objects.requireNonNull(confPerDomainName);
            confPerDomainName.forEach(this::addInternal);
            this.sniMappings = null;
            return this;
        }

        @Override
        public Builder setSniMappings(Map<String, Consumer<? super SslContextSpec>> confPerDomainName) {
            Objects.requireNonNull(confPerDomainName);
            this.confPerDomainName.clear();
            confPerDomainName.forEach(this::addInternal);
            this.sniMappings = null;
            return this;
        }

        @Override
        public Builder setSniAsyncMappings(AsyncMapping<String, SslProvider> mappings) {
            this.sniMappings = Objects.requireNonNull(mappings);
            this.confPerDomainName.clear();
            return this;
        }

        @Override
        public Builder serverNames(SNIServerName ... serverNames) {
            Objects.requireNonNull(serverNames);
            this.serverNames = Arrays.asList(serverNames);
            return this;
        }

        @Override
        public SslProvider build() {
            return new SslProvider(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Build)) {
                return false;
            }
            Build build = (Build)o;
            return this.handshakeTimeoutMillis == build.handshakeTimeoutMillis && this.closeNotifyFlushTimeoutMillis == build.closeNotifyFlushTimeoutMillis && this.closeNotifyReadTimeoutMillis == build.closeNotifyReadTimeoutMillis && Objects.equals(this.sslCtxBuilder, build.sslCtxBuilder) && this.type == build.type && Objects.equals(this.sslContext, build.sslContext) && Objects.equals(this.handlerConfigurator, build.handlerConfigurator) && Objects.equals(this.serverNames, build.serverNames) && this.confPerDomainName.equals(build.confPerDomainName) && Objects.equals(this.protocolSslContextSpec, build.protocolSslContextSpec);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sslCtxBuilder, this.type, this.sslContext, this.handlerConfigurator, this.handshakeTimeoutMillis, this.closeNotifyFlushTimeoutMillis, this.closeNotifyReadTimeoutMillis, this.serverNames, this.confPerDomainName, this.protocolSslContextSpec});
        }

        void addInternal(String domainName, Consumer<? super SslContextSpec> sslProviderBuilder) {
            Objects.requireNonNull(domainName, "domainName");
            Objects.requireNonNull(sslProviderBuilder, "sslProviderBuilder");
            SslContextSpec builder = SslProvider.builder();
            sslProviderBuilder.accept(builder);
            this.confPerDomainName.put(domainName, ((Builder)((Object)builder)).build());
        }
    }

    public static interface ProtocolSslContextSpec {
        public ProtocolSslContextSpec configure(Consumer<SslContextBuilder> var1);

        public SslContext sslContext() throws SSLException;
    }

    @Deprecated
    public static interface DefaultConfigurationSpec {
        public Builder defaultConfiguration(DefaultConfigurationType var1);
    }

    @Deprecated
    public static enum DefaultConfigurationType {
        NONE,
        TCP,
        H2;

    }

    public static interface SslContextSpec {
        public Builder sslContext(ProtocolSslContextSpec var1);

        public Builder sslContext(SslContext var1);

        @Deprecated
        public DefaultConfigurationSpec sslContext(SslContextBuilder var1);
    }

    public static interface Builder {
        public Builder handlerConfigurator(Consumer<? super SslHandler> var1);

        public Builder handshakeTimeout(Duration var1);

        public Builder handshakeTimeoutMillis(long var1);

        public Builder closeNotifyFlushTimeout(Duration var1);

        public Builder closeNotifyFlushTimeoutMillis(long var1);

        public Builder closeNotifyReadTimeout(Duration var1);

        public Builder closeNotifyReadTimeoutMillis(long var1);

        public Builder addSniMapping(String var1, Consumer<? super SslContextSpec> var2);

        public Builder addSniMappings(Map<String, Consumer<? super SslContextSpec>> var1);

        public Builder setSniMappings(Map<String, Consumer<? super SslContextSpec>> var1);

        public Builder setSniAsyncMappings(AsyncMapping<String, SslProvider> var1);

        public Builder serverNames(SNIServerName ... var1);

        public SslProvider build();
    }
}

