/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexConstructor;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.MetadataIndexNodeType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.writer.LocalTsFileOutput;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.apache.iotdb.tsfile.write.writer.tsmiterator.TSMIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileIOWriter
implements AutoCloseable {
    protected static final byte[] MAGIC_STRING_BYTES;
    public static final byte VERSION_NUMBER_BYTE;
    protected static final TSFileConfig config;
    private static final Logger logger;
    private static final Logger resourceLogger;
    protected TsFileOutput out;
    protected boolean canWrite = true;
    protected File file;
    protected ChunkMetadata currentChunkMetadata;
    protected List<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
    protected List<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
    private long markedPosition;
    private String currentChunkGroupDeviceId;
    private long minPlanIndex;
    private long maxPlanIndex;
    protected long maxMetadataSize;
    protected long currentChunkMetadataSize = 0L;
    protected File chunkMetadataTempFile;
    protected LocalTsFileOutput tempOutput;
    protected volatile boolean hasChunkMetadataInDisk = false;
    protected int pathCount = 0;
    protected boolean enableMemoryControl = false;
    private Path lastSerializePath = null;
    protected LinkedList<Long> endPosInCMTForDevice = new LinkedList();
    private volatile int chunkMetadataCount = 0;
    public static final String CHUNK_METADATA_TEMP_FILE_SUFFIX = ".meta";

    protected TsFileIOWriter() {
    }

    public TsFileIOWriter(File file) throws IOException {
        this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(file.getPath(), false);
        this.file = file;
        if (resourceLogger.isDebugEnabled()) {
            resourceLogger.debug("{} writer is opened.", (Object)file.getName());
        }
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput output) throws IOException {
        this.out = output;
        this.startFile();
    }

    public TsFileIOWriter(TsFileOutput output, boolean test) {
        this.out = output;
    }

    public TsFileIOWriter(File file, boolean enableMemoryControl, long maxMetadataSize) throws IOException {
        this(file);
        this.enableMemoryControl = enableMemoryControl;
        this.maxMetadataSize = maxMetadataSize;
        this.chunkMetadataTempFile = new File(file.getAbsolutePath() + CHUNK_METADATA_TEMP_FILE_SUFFIX);
    }

    public void writeBytesToStream(PublicBAOS bytes) throws IOException {
        bytes.writeTo(this.out.wrapAsStream());
    }

    protected void startFile() throws IOException {
        this.out.write(MAGIC_STRING_BYTES);
        this.out.write(VERSION_NUMBER_BYTE);
    }

    public int startChunkGroup(String deviceId) throws IOException {
        this.currentChunkGroupDeviceId = deviceId;
        if (logger.isDebugEnabled()) {
            logger.debug("start chunk group:{}, file position {}", (Object)deviceId, (Object)this.out.getPosition());
        }
        this.chunkMetadataList = new ArrayList<ChunkMetadata>();
        ChunkGroupHeader chunkGroupHeader = new ChunkGroupHeader(this.currentChunkGroupDeviceId);
        return chunkGroupHeader.serializeTo(this.out.wrapAsStream());
    }

    public void endChunkGroup() throws IOException {
        if (this.currentChunkGroupDeviceId == null || this.chunkMetadataList.isEmpty()) {
            return;
        }
        this.chunkGroupMetadataList.add(new ChunkGroupMetadata(this.currentChunkGroupDeviceId, this.chunkMetadataList));
        this.currentChunkGroupDeviceId = null;
        this.chunkMetadataList = null;
        this.out.flush();
    }

    public boolean isWritingChunkGroup() {
        return this.currentChunkGroupDeviceId != null;
    }

    public void startFlushChunk(String measurementId, CompressionType compressionCodecName, TSDataType tsDataType, TSEncoding encodingType, Statistics<? extends Serializable> statistics, int dataSize, int numOfPages, int mask) throws IOException {
        this.currentChunkMetadata = new ChunkMetadata(measurementId, tsDataType, this.out.getPosition(), statistics);
        this.currentChunkMetadata.setMask((byte)mask);
        ChunkHeader header = new ChunkHeader(measurementId, dataSize, tsDataType, compressionCodecName, encodingType, numOfPages, mask);
        header.serializeTo(this.out.wrapAsStream());
    }

    public void writeChunk(Chunk chunk, ChunkMetadata chunkMetadata) throws IOException {
        ChunkHeader chunkHeader = chunk.getHeader();
        this.currentChunkMetadata = new ChunkMetadata(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), this.out.getPosition(), chunkMetadata.getStatistics());
        chunkHeader.serializeTo(this.out.wrapAsStream());
        this.out.write(chunk.getData());
        this.endCurrentChunk();
        if (logger.isDebugEnabled()) {
            logger.debug("end flushing a chunk:{}, totalvalue:{}", (Object)chunkHeader.getMeasurementID(), (Object)chunkMetadata.getNumOfPoints());
        }
    }

    public void writeEmptyValueChunk(String measurementId, CompressionType compressionType, TSDataType tsDataType, TSEncoding encodingType, Statistics<? extends Serializable> statistics) throws IOException {
        this.currentChunkMetadata = new ChunkMetadata(measurementId, tsDataType, this.out.getPosition(), statistics);
        this.currentChunkMetadata.setMask((byte)64);
        ChunkHeader emptyChunkHeader = new ChunkHeader(measurementId, 0, tsDataType, compressionType, encodingType, 0, 64);
        emptyChunkHeader.serializeTo(this.out.wrapAsStream());
        this.endCurrentChunk();
    }

    public void writeChunk(Chunk chunk) throws IOException {
        ChunkHeader chunkHeader = chunk.getHeader();
        this.currentChunkMetadata = new ChunkMetadata(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), this.out.getPosition(), chunk.getChunkStatistic());
        chunkHeader.serializeTo(this.out.wrapAsStream());
        this.out.write(chunk.getData());
        this.endCurrentChunk();
    }

    public void endCurrentChunk() {
        if (this.enableMemoryControl) {
            this.currentChunkMetadataSize += this.currentChunkMetadata.calculateRamSize();
        }
        ++this.chunkMetadataCount;
        this.chunkMetadataList.add(this.currentChunkMetadata);
        this.currentChunkMetadata = null;
    }

    public void endFile() throws IOException {
        File chunkMetadataFile;
        long startTime = System.currentTimeMillis();
        this.checkInMemoryPathCount();
        this.readChunkMetadataAndConstructIndexTree();
        long footerIndex = this.out.getPosition();
        if (logger.isDebugEnabled()) {
            logger.debug("start to flush the footer,file pos:{}", (Object)footerIndex);
        }
        this.out.write(MAGIC_STRING_BYTES);
        this.out.close();
        if (resourceLogger.isDebugEnabled() && this.file != null) {
            resourceLogger.debug("{} writer is closed.", (Object)this.file.getName());
        }
        if (this.file != null && (chunkMetadataFile = new File(this.file.getAbsolutePath() + CHUNK_METADATA_TEMP_FILE_SUFFIX)).exists()) {
            FileUtils.delete(chunkMetadataFile);
        }
        this.canWrite = false;
        long cost = System.currentTimeMillis() - startTime;
        logger.info("Time for flushing metadata is {} ms", (Object)cost);
    }

    private void checkInMemoryPathCount() {
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            this.pathCount += chunkGroupMetadata.getChunkMetadataList().size();
        }
    }

    private void readChunkMetadataAndConstructIndexTree() throws IOException {
        if (this.tempOutput != null) {
            this.tempOutput.close();
        }
        long metaOffset = this.out.getPosition();
        ReadWriteIOUtils.write((byte)2, this.out.wrapAsStream());
        TSMIterator tsmIterator = this.hasChunkMetadataInDisk ? TSMIterator.getTSMIteratorInDisk(this.chunkMetadataTempFile, this.chunkGroupMetadataList, this.endPosInCMTForDevice) : TSMIterator.getTSMIteratorInMemory(this.chunkGroupMetadataList);
        TreeMap<String, MetadataIndexNode> deviceMetadataIndexMap = new TreeMap<String, MetadataIndexNode>();
        ArrayDeque<MetadataIndexNode> measurementMetadataIndexQueue = new ArrayDeque<MetadataIndexNode>();
        String currentDevice = null;
        String prevDevice = null;
        Path currentPath = null;
        MetadataIndexNode currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
        TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
        int seriesIdxForCurrDevice = 0;
        BloomFilter filter = BloomFilter.getEmptyBloomFilter(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate(), this.pathCount);
        int indexCount = 0;
        while (tsmIterator.hasNext()) {
            Pair<Path, TimeseriesMetadata> timeseriesMetadataPair = tsmIterator.next();
            TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)timeseriesMetadataPair.right;
            currentPath = (Path)timeseriesMetadataPair.left;
            ++indexCount;
            filter.add(currentPath.getFullPath());
            currentDevice = currentPath.getDevice();
            if (!currentDevice.equals(prevDevice)) {
                if (prevDevice != null) {
                    MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, this.out);
                    deviceMetadataIndexMap.put(prevDevice, MetadataIndexConstructor.generateRootNode(measurementMetadataIndexQueue, this.out, MetadataIndexNodeType.INTERNAL_MEASUREMENT));
                    currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
                }
                measurementMetadataIndexQueue = new ArrayDeque();
                seriesIdxForCurrDevice = 0;
            }
            if (seriesIdxForCurrDevice % config.getMaxDegreeOfIndexNode() == 0) {
                if (currentIndexNode.isFull()) {
                    MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, this.out);
                    currentIndexNode = new MetadataIndexNode(MetadataIndexNodeType.LEAF_MEASUREMENT);
                }
                if (timeseriesMetadata.getTsDataType() != TSDataType.VECTOR) {
                    currentIndexNode.addEntry(new MetadataIndexEntry(currentPath.getMeasurement(), this.out.getPosition()));
                } else {
                    currentIndexNode.addEntry(new MetadataIndexEntry("", this.out.getPosition()));
                }
            }
            prevDevice = currentDevice;
            ++seriesIdxForCurrDevice;
            timeseriesMetadata.serializeTo(this.out.wrapAsStream());
        }
        MetadataIndexConstructor.addCurrentIndexNodeToQueue(currentIndexNode, measurementMetadataIndexQueue, this.out);
        if (prevDevice != null) {
            deviceMetadataIndexMap.put(prevDevice, MetadataIndexConstructor.generateRootNode(measurementMetadataIndexQueue, this.out, MetadataIndexNodeType.INTERNAL_MEASUREMENT));
        }
        MetadataIndexNode metadataIndex = MetadataIndexConstructor.checkAndBuildLevelIndex(deviceMetadataIndexMap, this.out);
        TsFileMetadata tsFileMetadata = new TsFileMetadata();
        tsFileMetadata.setMetadataIndex(metadataIndex);
        tsFileMetadata.setMetaOffset(metaOffset);
        int size = tsFileMetadata.serializeTo(this.out.wrapAsStream());
        ReadWriteIOUtils.write(size += tsFileMetadata.serializeBloomFilter(this.out.wrapAsStream(), filter), this.out.wrapAsStream());
    }

    public long getPos() throws IOException {
        return this.out.getPosition();
    }

    public Map<String, List<ChunkMetadata>> getDeviceChunkMetadataMap() {
        HashMap<String, List<ChunkMetadata>> deviceChunkMetadataMap = new HashMap<String, List<ChunkMetadata>>();
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            deviceChunkMetadataMap.computeIfAbsent(chunkGroupMetadata.getDevice(), k -> new ArrayList()).addAll(chunkGroupMetadata.getChunkMetadataList());
        }
        return deviceChunkMetadataMap;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public void mark() throws IOException {
        this.markedPosition = this.getPos();
    }

    public void reset() throws IOException {
        this.out.truncate(this.markedPosition);
    }

    @Override
    public void close() throws IOException {
        this.canWrite = false;
        this.out.close();
        if (this.tempOutput != null) {
            this.tempOutput.close();
        }
    }

    void writeSeparatorMaskForTest() throws IOException {
        this.out.write(new byte[]{2});
    }

    void writeChunkGroupMarkerForTest() throws IOException {
        this.out.write(new byte[]{0});
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void filterChunks(Map<Path, List<Long>> chunkStartTimes) {
        HashMap<Path, Integer> startTimeIdxes = new HashMap<Path, Integer>();
        chunkStartTimes.forEach((p, t2) -> startTimeIdxes.put((Path)p, 0));
        Iterator<ChunkGroupMetadata> chunkGroupMetaDataIterator = this.chunkGroupMetadataList.iterator();
        while (chunkGroupMetaDataIterator.hasNext()) {
            ChunkGroupMetadata chunkGroupMetaData = chunkGroupMetaDataIterator.next();
            String deviceId = chunkGroupMetaData.getDevice();
            int chunkNum = chunkGroupMetaData.getChunkMetadataList().size();
            Iterator<ChunkMetadata> chunkMetaDataIterator = chunkGroupMetaData.getChunkMetadataList().iterator();
            while (chunkMetaDataIterator.hasNext()) {
                List<Long> pathChunkStartTimes;
                boolean chunkValid;
                IChunkMetadata chunkMetaData = chunkMetaDataIterator.next();
                Path path = new Path(deviceId, chunkMetaData.getMeasurementUid(), true);
                int startTimeIdx = (Integer)startTimeIdxes.get(path);
                boolean bl = chunkValid = startTimeIdx < (pathChunkStartTimes = chunkStartTimes.get(path)).size() && pathChunkStartTimes.get(startTimeIdx).longValue() == chunkMetaData.getStartTime();
                if (!chunkValid) {
                    chunkMetaDataIterator.remove();
                    --chunkNum;
                    continue;
                }
                startTimeIdxes.put(path, startTimeIdx + 1);
            }
            if (chunkNum != 0) continue;
            chunkGroupMetaDataIterator.remove();
        }
    }

    public void writePlanIndices() throws IOException {
        ReadWriteIOUtils.write((byte)4, this.out.wrapAsStream());
        ReadWriteIOUtils.write(this.minPlanIndex, this.out.wrapAsStream());
        ReadWriteIOUtils.write(this.maxPlanIndex, this.out.wrapAsStream());
        this.out.flush();
    }

    public void truncate(long offset) throws IOException {
        this.out.truncate(offset);
    }

    public TsFileOutput getIOWriterOut() {
        return this.out;
    }

    public List<ChunkMetadata> getChunkMetadataListOfCurrentDeviceInMemory() {
        return this.chunkMetadataList;
    }

    public Map<String, List<TimeseriesMetadata>> getDeviceTimeseriesMetadataMap() {
        TreeMap<String, List<TimeseriesMetadata>> deviceTimeseriesMetadataMap = new TreeMap<String, List<TimeseriesMetadata>>();
        TreeMap<String, Map> chunkMetadataMap = new TreeMap<String, Map>();
        for (ChunkGroupMetadata chunkGroupMetadata : this.chunkGroupMetadataList) {
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                chunkMetadataMap.computeIfAbsent(chunkGroupMetadata.getDevice(), x -> new TreeMap()).computeIfAbsent(chunkMetadata.getMeasurementUid(), x -> new ArrayList()).add(chunkMetadata);
            }
        }
        for (String device : chunkMetadataMap.keySet()) {
            Map seriesToChunkMetadataMap = (Map)chunkMetadataMap.get(device);
            for (Map.Entry entry : seriesToChunkMetadataMap.entrySet()) {
                try {
                    deviceTimeseriesMetadataMap.computeIfAbsent(device, x -> new ArrayList()).add(TSMIterator.constructOneTimeseriesMetadata((String)entry.getKey(), (List)entry.getValue()));
                }
                catch (IOException e) {
                    logger.error("Failed to get device timeseries metadata map", e);
                    return null;
                }
            }
        }
        return deviceTimeseriesMetadataMap;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    public int checkMetadataSizeAndMayFlush() throws IOException {
        if (this.enableMemoryControl && this.currentChunkMetadataSize > this.maxMetadataSize) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Flushing chunk metadata, total size is {}, count is {}, avg size is {}", this.currentChunkMetadataSize, this.chunkMetadataCount, this.currentChunkMetadataSize / (long)this.chunkMetadataCount);
                }
                return this.sortAndFlushChunkMetadata();
            }
            catch (IOException e) {
                logger.error("Meets exception when flushing metadata to temp file for {}", (Object)this.file, (Object)e);
                throw e;
            }
        }
        return 0;
    }

    protected int sortAndFlushChunkMetadata() throws IOException {
        int writtenSize = 0;
        List<Pair<Path, List<IChunkMetadata>>> sortedChunkMetadataList = TSMIterator.sortChunkMetadata(this.chunkGroupMetadataList, this.currentChunkGroupDeviceId, this.chunkMetadataList);
        if (this.tempOutput == null) {
            this.tempOutput = new LocalTsFileOutput(new FileOutputStream(this.chunkMetadataTempFile));
        }
        this.hasChunkMetadataInDisk = true;
        for (Pair<Path, List<IChunkMetadata>> pair : sortedChunkMetadataList) {
            boolean isNewPath;
            Path seriesPath = (Path)pair.left;
            boolean bl = isNewPath = !seriesPath.equals(this.lastSerializePath);
            if (isNewPath) {
                ++this.pathCount;
            }
            List iChunkMetadataList = (List)pair.right;
            writtenSize += this.writeChunkMetadataToTempFile(iChunkMetadataList, seriesPath, isNewPath);
            this.lastSerializePath = seriesPath;
            logger.debug("Flushing {}", (Object)seriesPath);
        }
        this.chunkGroupMetadataList.clear();
        if (this.chunkMetadataList != null) {
            this.chunkMetadataList.clear();
        }
        this.chunkMetadataCount = 0;
        this.currentChunkMetadataSize = 0L;
        return writtenSize;
    }

    private int writeChunkMetadataToTempFile(List<IChunkMetadata> iChunkMetadataList, Path seriesPath, boolean isNewPath) throws IOException {
        int writtenSize = 0;
        if (this.lastSerializePath == null || !seriesPath.getDevice().equals(this.lastSerializePath.getDevice())) {
            this.endPosInCMTForDevice.add(this.tempOutput.getPosition());
            writtenSize += ReadWriteIOUtils.write(seriesPath.getDevice(), this.tempOutput.wrapAsStream());
        }
        if (isNewPath && iChunkMetadataList.size() > 0) {
            writtenSize += ReadWriteIOUtils.writeVar(seriesPath.getMeasurement(), this.tempOutput.wrapAsStream());
            writtenSize += ReadWriteIOUtils.write(iChunkMetadataList.get(0).getDataType(), this.tempOutput.wrapAsStream());
        }
        PublicBAOS buffer = new PublicBAOS();
        int totalSize = 0;
        for (IChunkMetadata chunkMetadata : iChunkMetadataList) {
            totalSize += chunkMetadata.serializeTo(buffer, true);
        }
        writtenSize += ReadWriteIOUtils.write(totalSize, this.tempOutput.wrapAsStream());
        buffer.writeTo(this.tempOutput);
        return writtenSize += buffer.size();
    }

    public String getCurrentChunkGroupDeviceId() {
        return this.currentChunkGroupDeviceId;
    }

    public List<ChunkGroupMetadata> getChunkGroupMetadataList() {
        return this.chunkGroupMetadataList;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    static {
        config = TSFileDescriptor.getInstance().getConfig();
        logger = LoggerFactory.getLogger(TsFileIOWriter.class);
        resourceLogger = LoggerFactory.getLogger("FileMonitor");
        MAGIC_STRING_BYTES = BytesUtils.stringToBytes("TsFile");
        VERSION_NUMBER_BYTE = (byte)3;
    }
}

