/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.tsfile.exception.PathParseException;
import org.apache.iotdb.tsfile.read.common.parser.PathNodesGenerator;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Path
implements Serializable,
Comparable<Path> {
    private static final long serialVersionUID = 3405277066329298200L;
    private String measurement;
    protected String device;
    protected String fullPath;
    private static final String ILLEGAL_PATH_ARGUMENT = "Path parameter is null";

    public Path() {
    }

    public Path(String pathSc) {
        this(pathSc, false);
    }

    public Path(String pathSc, boolean needSplit) {
        if (pathSc == null) {
            throw new PathParseException(ILLEGAL_PATH_ARGUMENT);
        }
        if (!needSplit) {
            this.fullPath = pathSc;
        } else if (pathSc.length() > 0) {
            String[] nodes = PathNodesGenerator.splitPathToNodes(pathSc);
            this.device = "";
            if (nodes.length > 1) {
                this.device = this.transformNodesToString(nodes, nodes.length - 1);
            }
            this.measurement = nodes[nodes.length - 1];
            this.fullPath = this.transformNodesToString(nodes, nodes.length);
        } else {
            this.fullPath = pathSc;
            this.device = "";
            this.measurement = pathSc;
        }
    }

    public Path(String device, String measurement, boolean needCheck) {
        if (device == null || measurement == null) {
            throw new PathParseException(ILLEGAL_PATH_ARGUMENT);
        }
        if (!needCheck) {
            this.measurement = measurement;
            this.device = device;
            this.fullPath = device + "." + measurement;
            return;
        }
        if (!StringUtils.isEmpty(device) && !StringUtils.isEmpty(measurement)) {
            String path = device + "." + measurement;
            String[] nodes = PathNodesGenerator.splitPathToNodes(path);
            this.device = this.transformNodesToString(nodes, nodes.length - 1);
            this.measurement = nodes[nodes.length - 1];
            this.fullPath = this.transformNodesToString(nodes, nodes.length);
        } else if (!StringUtils.isEmpty(device)) {
            String[] deviceNodes = PathNodesGenerator.splitPathToNodes(device);
            this.device = this.transformNodesToString(deviceNodes, deviceNodes.length);
            this.measurement = measurement;
            this.fullPath = device + "." + measurement;
        } else if (!StringUtils.isEmpty(measurement)) {
            String[] measurementNodes = PathNodesGenerator.splitPathToNodes(measurement);
            this.measurement = this.transformNodesToString(measurementNodes, measurementNodes.length);
            this.device = device;
            this.fullPath = measurement;
        } else {
            this.device = device;
            this.measurement = measurement;
            this.fullPath = "";
        }
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getDevice() {
        return this.device;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public String getFullPathWithAlias() {
        throw new IllegalArgumentException("doesn't alias in TSFile Path");
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Path && this.fullPath.equals(((Path)obj).fullPath);
    }

    public boolean equals(String obj) {
        return this.fullPath.equals(obj);
    }

    @Override
    public int compareTo(Path path) {
        return this.fullPath.compareTo(path.getFullPath());
    }

    public String toString() {
        return this.fullPath;
    }

    public Path clone() {
        return new Path(this.fullPath);
    }

    public int getColumnNum() {
        return 1;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((byte)3, byteBuffer);
        this.serializeWithoutType(byteBuffer);
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)3, stream);
        this.serializeWithoutType(stream);
    }

    public void serialize(PublicBAOS stream) throws IOException {
        ReadWriteIOUtils.write((byte)3, (OutputStream)stream);
        this.serializeWithoutType(stream);
    }

    protected void serializeWithoutType(ByteBuffer byteBuffer) {
        if (this.measurement == null) {
            ReadWriteIOUtils.write((byte)0, byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, byteBuffer);
            ReadWriteIOUtils.write(this.measurement, byteBuffer);
        }
        if (this.device == null) {
            ReadWriteIOUtils.write((byte)0, byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, byteBuffer);
            ReadWriteIOUtils.write(this.device, byteBuffer);
        }
        if (this.fullPath == null) {
            ReadWriteIOUtils.write((byte)0, byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, byteBuffer);
            ReadWriteIOUtils.write(this.fullPath, byteBuffer);
        }
    }

    protected void serializeWithoutType(OutputStream stream) throws IOException {
        if (this.measurement == null) {
            ReadWriteIOUtils.write((byte)0, stream);
        } else {
            ReadWriteIOUtils.write((byte)1, stream);
            ReadWriteIOUtils.write(this.measurement, stream);
        }
        if (this.device == null) {
            ReadWriteIOUtils.write((byte)0, stream);
        } else {
            ReadWriteIOUtils.write((byte)1, stream);
            ReadWriteIOUtils.write(this.device, stream);
        }
        if (this.fullPath == null) {
            ReadWriteIOUtils.write((byte)0, stream);
        } else {
            ReadWriteIOUtils.write((byte)1, stream);
            ReadWriteIOUtils.write(this.fullPath, stream);
        }
    }

    protected void serializeWithoutType(PublicBAOS stream) throws IOException {
        if (this.measurement == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write(this.measurement, (OutputStream)stream);
        }
        if (this.device == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write(this.device, (OutputStream)stream);
        }
        if (this.fullPath == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write(this.fullPath, (OutputStream)stream);
        }
    }

    public static Path deserialize(ByteBuffer byteBuffer) {
        Path path = new Path();
        byte isNull = ReadWriteIOUtils.readByte(byteBuffer);
        path.measurement = isNull == 0 ? null : ReadWriteIOUtils.readString(byteBuffer);
        isNull = ReadWriteIOUtils.readByte(byteBuffer);
        path.device = isNull == 0 ? null : ReadWriteIOUtils.readString(byteBuffer);
        isNull = ReadWriteIOUtils.readByte(byteBuffer);
        path.fullPath = isNull == 0 ? null : ReadWriteIOUtils.readString(byteBuffer);
        return path;
    }

    private String transformNodesToString(String[] nodes, int index) {
        Validate.isTrue(nodes.length > 0);
        StringBuilder s2 = new StringBuilder(nodes[0]);
        for (int i = 1; i < index; ++i) {
            s2.append(".");
            s2.append(nodes[i]);
        }
        return s2.toString();
    }
}

