/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class DescReadBatchData
extends BatchData {
    public DescReadBatchData() {
        this.batchDataType = BatchData.BatchDataType.DESC_READ;
    }

    public DescReadBatchData(TSDataType dataType) {
        super(dataType);
        this.batchDataType = BatchData.BatchDataType.DESC_READ;
    }

    @Override
    public boolean hasCurrent() {
        return this.readCurListIndex >= 0 && this.readCurArrayIndex >= 0;
    }

    @Override
    public void next() {
        --this.readCurArrayIndex;
        if (this.readCurArrayIndex == -1) {
            this.readCurArrayIndex = this.capacity - 1;
            --this.readCurListIndex;
        }
    }

    @Override
    public void resetBatchData() {
        this.readCurArrayIndex = this.writeCurArrayIndex - 1;
        this.readCurListIndex = this.writeCurListIndex;
    }

    @Override
    public BatchData flip() {
        this.readCurArrayIndex = this.writeCurArrayIndex - 1;
        this.readCurListIndex = this.writeCurListIndex;
        return this;
    }

    @Override
    public Object getValueInTimestamp(long time) {
        while (this.hasCurrent()) {
            if (this.currentTime() > time) {
                this.next();
                continue;
            }
            if (this.currentTime() == time) {
                Object value = this.currentValue();
                this.next();
                return value;
            }
            return null;
        }
        return null;
    }
}

