/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fileOutputFactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.fileOutputFactory.FileOutputFactory;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSOutputFactory
implements FileOutputFactory {
    private static final Logger logger = LoggerFactory.getLogger(HDFSOutputFactory.class);
    private Constructor constructor;

    public HDFSOutputFactory() {
        try {
            Class<?> clazz = Class.forName(TSFileDescriptor.getInstance().getConfig().getHdfsTsFileOutput());
            this.constructor = clazz.getConstructor(String.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get HDFSInput in Hadoop file system. Please check your dependency of Hadoop module.", e);
        }
    }

    @Override
    public TsFileOutput getTsFileOutput(String filePath, boolean append) {
        try {
            return (TsFileOutput)this.constructor.newInstance(filePath, !append);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get TsFile output of file: {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }
}

