/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class SessionUtils {
    private static final byte TYPE_NULL = -2;

    public static ByteBuffer getTimeBuffer(Tablet tablet) {
        ByteBuffer timeBuffer = ByteBuffer.allocate(tablet.getTimeBytesSize());
        for (int i = 0; i < tablet.rowSize; ++i) {
            timeBuffer.putLong(tablet.timestamps[i]);
        }
        timeBuffer.flip();
        return timeBuffer;
    }

    public static ByteBuffer getValueBuffer(Tablet tablet) {
        ByteBuffer valueBuffer = ByteBuffer.allocate(tablet.getTotalValueOccupation());
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            MeasurementSchema schema = tablet.getSchemas().get(i);
            SessionUtils.getValueBufferOfDataType(schema.getType(), tablet, i, valueBuffer);
        }
        if (tablet.bitMaps != null) {
            for (BitMap bitMap : tablet.bitMaps) {
                boolean columnHasNull = bitMap != null && !bitMap.isAllUnmarked();
                valueBuffer.put(BytesUtils.boolToByte(columnHasNull));
                if (!columnHasNull) continue;
                byte[] bytes = bitMap.getByteArray();
                for (int j = 0; j < tablet.rowSize / 8 + 1; ++j) {
                    valueBuffer.put(bytes[j]);
                }
            }
        }
        valueBuffer.flip();
        return valueBuffer;
    }

    public static ByteBuffer getValueBuffer(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        ByteBuffer buffer = ByteBuffer.allocate(SessionUtils.calculateLength(types, values));
        SessionUtils.putValues(types, values, buffer);
        return buffer;
    }

    private static int calculateLength(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        int res = 0;
        block8: for (int i = 0; i < types.size(); ++i) {
            ++res;
            switch (types.get(i)) {
                case BOOLEAN: {
                    ++res;
                    continue block8;
                }
                case INT32: {
                    res += 4;
                    continue block8;
                }
                case INT64: {
                    res += 8;
                    continue block8;
                }
                case FLOAT: {
                    res += 4;
                    continue block8;
                }
                case DOUBLE: {
                    res += 8;
                    continue block8;
                }
                case TEXT: {
                    res += 4;
                    if (values.get(i) instanceof Binary) {
                        res += ((Binary)values.get(i)).getValues().length;
                        continue block8;
                    }
                    res += ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET).length;
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + (Object)((Object)types.get(i)));
                }
            }
        }
        return res;
    }

    private static void putValues(List<TSDataType> types, List<Object> values, ByteBuffer buffer) throws IoTDBConnectionException {
        block8: for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) {
                ReadWriteIOUtils.write((byte)-2, buffer);
                continue;
            }
            ReadWriteIOUtils.write(types.get(i), buffer);
            switch (types.get(i)) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)values.get(i), buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)values.get(i)), buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)values.get(i)), buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write(((Float)values.get(i)).floatValue(), buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)values.get(i)), buffer);
                    continue block8;
                }
                case TEXT: {
                    byte[] bytes = values.get(i) instanceof Binary ? ((Binary)values.get(i)).getValues() : ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET);
                    ReadWriteIOUtils.write(bytes.length, buffer);
                    buffer.put(bytes);
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + (Object)((Object)types.get(i)));
                }
            }
        }
        buffer.flip();
    }

    private static void getValueBufferOfDataType(TSDataType dataType, Tablet tablet, int i, ByteBuffer valueBuffer) {
        switch (dataType) {
            case INT32: {
                int[] intValues = (int[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putInt(intValues[index]);
                        continue;
                    }
                    valueBuffer.putInt(Integer.MIN_VALUE);
                }
                break;
            }
            case INT64: {
                long[] longValues = (long[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putLong(longValues[index]);
                        continue;
                    }
                    valueBuffer.putLong(Long.MIN_VALUE);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = (float[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putFloat(floatValues[index]);
                        continue;
                    }
                    valueBuffer.putFloat(Float.MIN_VALUE);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.putDouble(doubleValues[index]);
                        continue;
                    }
                    valueBuffer.putDouble(Double.MIN_VALUE);
                }
                break;
            }
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    if (tablet.bitMaps == null || tablet.bitMaps[i] == null || !tablet.bitMaps[i].isMarked(index)) {
                        valueBuffer.put(BytesUtils.boolToByte(boolValues[index]));
                        continue;
                    }
                    valueBuffer.put(BytesUtils.boolToByte(false));
                }
                break;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])tablet.values[i];
                for (int index = 0; index < tablet.rowSize; ++index) {
                    valueBuffer.putInt(binaryValues[index].getLength());
                    valueBuffer.put(binaryValues[index].getValues());
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{dataType}));
            }
        }
    }

    public static List<TEndPoint> parseSeedNodeUrls(List<String> nodeUrls) {
        if (nodeUrls == null) {
            throw new NumberFormatException("nodeUrls is null");
        }
        ArrayList<TEndPoint> endPointsList = new ArrayList<TEndPoint>();
        for (String nodeUrl : nodeUrls) {
            TEndPoint endPoint = SessionUtils.parseNodeUrl(nodeUrl);
            endPointsList.add(endPoint);
        }
        return endPointsList;
    }

    private static TEndPoint parseNodeUrl(String nodeUrl) {
        TEndPoint endPoint = new TEndPoint();
        String[] split2 = nodeUrl.split(":");
        if (split2.length != 2) {
            throw new NumberFormatException("NodeUrl Incorrect format");
        }
        String ip = split2[0];
        try {
            int rpcPort = Integer.parseInt(split2[1]);
            return endPoint.setIp(ip).setPort(rpcPort);
        }
        catch (Exception e) {
            throw new NumberFormatException("NodeUrl Incorrect format");
        }
    }

    private SessionUtils() {
    }
}

