/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mpp.rpc.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.mpp.rpc.thrift.TLoadSample;
import org.apache.iotdb.mpp.rpc.thrift.TSchemaLimitLevel;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class THeartbeatResp
implements TBase<THeartbeatResp, _Fields>,
Serializable,
Cloneable,
Comparable<THeartbeatResp> {
    private static final TStruct STRUCT_DESC = new TStruct("THeartbeatResp");
    private static final TField HEARTBEAT_TIMESTAMP_FIELD_DESC = new TField("heartbeatTimestamp", 10, 1);
    private static final TField STATUS_FIELD_DESC = new TField("status", 11, 2);
    private static final TField STATUS_REASON_FIELD_DESC = new TField("statusReason", 11, 3);
    private static final TField JUDGED_LEADERS_FIELD_DESC = new TField("judgedLeaders", 13, 4);
    private static final TField LOAD_SAMPLE_FIELD_DESC = new TField("loadSample", 12, 5);
    private static final TField REGION_DEVICE_NUM_MAP_FIELD_DESC = new TField("regionDeviceNumMap", 13, 6);
    private static final TField REGION_TIME_SERIES_NUM_MAP_FIELD_DESC = new TField("regionTimeSeriesNumMap", 13, 7);
    private static final TField REGION_DISK_FIELD_DESC = new TField("regionDisk", 13, 8);
    private static final TField SCHEMA_LIMIT_LEVEL_FIELD_DESC = new TField("schemaLimitLevel", 8, 9);
    private static final TField PIPE_META_LIST_FIELD_DESC = new TField("pipeMetaList", 15, 10);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new THeartbeatRespStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new THeartbeatRespTupleSchemeFactory();
    public long heartbeatTimestamp;
    @Nullable
    public String status;
    @Nullable
    public String statusReason;
    @Nullable
    public Map<TConsensusGroupId, Boolean> judgedLeaders;
    @Nullable
    public TLoadSample loadSample;
    @Nullable
    public Map<Integer, Long> regionDeviceNumMap;
    @Nullable
    public Map<Integer, Long> regionTimeSeriesNumMap;
    @Nullable
    public Map<Integer, Long> regionDisk;
    @Nullable
    public TSchemaLimitLevel schemaLimitLevel;
    @Nullable
    public List<ByteBuffer> pipeMetaList;
    private static final int __HEARTBEATTIMESTAMP_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.STATUS_REASON, _Fields.JUDGED_LEADERS, _Fields.LOAD_SAMPLE, _Fields.REGION_DEVICE_NUM_MAP, _Fields.REGION_TIME_SERIES_NUM_MAP, _Fields.REGION_DISK, _Fields.SCHEMA_LIMIT_LEVEL, _Fields.PIPE_META_LIST};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public THeartbeatResp() {
    }

    public THeartbeatResp(long heartbeatTimestamp, String status) {
        this();
        this.heartbeatTimestamp = heartbeatTimestamp;
        this.setHeartbeatTimestampIsSet(true);
        this.status = status;
    }

    public THeartbeatResp(THeartbeatResp other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.heartbeatTimestamp = other.heartbeatTimestamp;
        if (other.isSetStatus()) {
            this.status = other.status;
        }
        if (other.isSetStatusReason()) {
            this.statusReason = other.statusReason;
        }
        if (other.isSetJudgedLeaders()) {
            HashMap<TConsensusGroupId, Boolean> __this__judgedLeaders = new HashMap<TConsensusGroupId, Boolean>(other.judgedLeaders.size());
            for (Map.Entry<TConsensusGroupId, Boolean> other_element : other.judgedLeaders.entrySet()) {
                TConsensusGroupId other_element_key = other_element.getKey();
                Boolean other_element_value = other_element.getValue();
                TConsensusGroupId __this__judgedLeaders_copy_key = new TConsensusGroupId(other_element_key);
                Boolean __this__judgedLeaders_copy_value = other_element_value;
                __this__judgedLeaders.put(__this__judgedLeaders_copy_key, __this__judgedLeaders_copy_value);
            }
            this.judgedLeaders = __this__judgedLeaders;
        }
        if (other.isSetLoadSample()) {
            this.loadSample = new TLoadSample(other.loadSample);
        }
        if (other.isSetRegionDeviceNumMap()) {
            HashMap<Integer, Long> __this__regionDeviceNumMap = new HashMap<Integer, Long>(other.regionDeviceNumMap);
            this.regionDeviceNumMap = __this__regionDeviceNumMap;
        }
        if (other.isSetRegionTimeSeriesNumMap()) {
            HashMap<Integer, Long> __this__regionTimeSeriesNumMap = new HashMap<Integer, Long>(other.regionTimeSeriesNumMap);
            this.regionTimeSeriesNumMap = __this__regionTimeSeriesNumMap;
        }
        if (other.isSetRegionDisk()) {
            HashMap<Integer, Long> __this__regionDisk = new HashMap<Integer, Long>(other.regionDisk);
            this.regionDisk = __this__regionDisk;
        }
        if (other.isSetSchemaLimitLevel()) {
            this.schemaLimitLevel = other.schemaLimitLevel;
        }
        if (other.isSetPipeMetaList()) {
            ArrayList<ByteBuffer> __this__pipeMetaList = new ArrayList<ByteBuffer>(other.pipeMetaList);
            this.pipeMetaList = __this__pipeMetaList;
        }
    }

    @Override
    public THeartbeatResp deepCopy() {
        return new THeartbeatResp(this);
    }

    @Override
    public void clear() {
        this.setHeartbeatTimestampIsSet(false);
        this.heartbeatTimestamp = 0L;
        this.status = null;
        this.statusReason = null;
        this.judgedLeaders = null;
        this.loadSample = null;
        this.regionDeviceNumMap = null;
        this.regionTimeSeriesNumMap = null;
        this.regionDisk = null;
        this.schemaLimitLevel = null;
        this.pipeMetaList = null;
    }

    public long getHeartbeatTimestamp() {
        return this.heartbeatTimestamp;
    }

    public THeartbeatResp setHeartbeatTimestamp(long heartbeatTimestamp) {
        this.heartbeatTimestamp = heartbeatTimestamp;
        this.setHeartbeatTimestampIsSet(true);
        return this;
    }

    public void unsetHeartbeatTimestamp() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetHeartbeatTimestamp() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setHeartbeatTimestampIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public THeartbeatResp setStatus(@Nullable String status) {
        this.status = status;
        return this;
    }

    public void unsetStatus() {
        this.status = null;
    }

    public boolean isSetStatus() {
        return this.status != null;
    }

    public void setStatusIsSet(boolean value) {
        if (!value) {
            this.status = null;
        }
    }

    @Nullable
    public String getStatusReason() {
        return this.statusReason;
    }

    public THeartbeatResp setStatusReason(@Nullable String statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    public void unsetStatusReason() {
        this.statusReason = null;
    }

    public boolean isSetStatusReason() {
        return this.statusReason != null;
    }

    public void setStatusReasonIsSet(boolean value) {
        if (!value) {
            this.statusReason = null;
        }
    }

    public int getJudgedLeadersSize() {
        return this.judgedLeaders == null ? 0 : this.judgedLeaders.size();
    }

    public void putToJudgedLeaders(TConsensusGroupId key, boolean val) {
        if (this.judgedLeaders == null) {
            this.judgedLeaders = new HashMap<TConsensusGroupId, Boolean>();
        }
        this.judgedLeaders.put(key, val);
    }

    @Nullable
    public Map<TConsensusGroupId, Boolean> getJudgedLeaders() {
        return this.judgedLeaders;
    }

    public THeartbeatResp setJudgedLeaders(@Nullable Map<TConsensusGroupId, Boolean> judgedLeaders) {
        this.judgedLeaders = judgedLeaders;
        return this;
    }

    public void unsetJudgedLeaders() {
        this.judgedLeaders = null;
    }

    public boolean isSetJudgedLeaders() {
        return this.judgedLeaders != null;
    }

    public void setJudgedLeadersIsSet(boolean value) {
        if (!value) {
            this.judgedLeaders = null;
        }
    }

    @Nullable
    public TLoadSample getLoadSample() {
        return this.loadSample;
    }

    public THeartbeatResp setLoadSample(@Nullable TLoadSample loadSample) {
        this.loadSample = loadSample;
        return this;
    }

    public void unsetLoadSample() {
        this.loadSample = null;
    }

    public boolean isSetLoadSample() {
        return this.loadSample != null;
    }

    public void setLoadSampleIsSet(boolean value) {
        if (!value) {
            this.loadSample = null;
        }
    }

    public int getRegionDeviceNumMapSize() {
        return this.regionDeviceNumMap == null ? 0 : this.regionDeviceNumMap.size();
    }

    public void putToRegionDeviceNumMap(int key, long val) {
        if (this.regionDeviceNumMap == null) {
            this.regionDeviceNumMap = new HashMap<Integer, Long>();
        }
        this.regionDeviceNumMap.put(key, val);
    }

    @Nullable
    public Map<Integer, Long> getRegionDeviceNumMap() {
        return this.regionDeviceNumMap;
    }

    public THeartbeatResp setRegionDeviceNumMap(@Nullable Map<Integer, Long> regionDeviceNumMap) {
        this.regionDeviceNumMap = regionDeviceNumMap;
        return this;
    }

    public void unsetRegionDeviceNumMap() {
        this.regionDeviceNumMap = null;
    }

    public boolean isSetRegionDeviceNumMap() {
        return this.regionDeviceNumMap != null;
    }

    public void setRegionDeviceNumMapIsSet(boolean value) {
        if (!value) {
            this.regionDeviceNumMap = null;
        }
    }

    public int getRegionTimeSeriesNumMapSize() {
        return this.regionTimeSeriesNumMap == null ? 0 : this.regionTimeSeriesNumMap.size();
    }

    public void putToRegionTimeSeriesNumMap(int key, long val) {
        if (this.regionTimeSeriesNumMap == null) {
            this.regionTimeSeriesNumMap = new HashMap<Integer, Long>();
        }
        this.regionTimeSeriesNumMap.put(key, val);
    }

    @Nullable
    public Map<Integer, Long> getRegionTimeSeriesNumMap() {
        return this.regionTimeSeriesNumMap;
    }

    public THeartbeatResp setRegionTimeSeriesNumMap(@Nullable Map<Integer, Long> regionTimeSeriesNumMap) {
        this.regionTimeSeriesNumMap = regionTimeSeriesNumMap;
        return this;
    }

    public void unsetRegionTimeSeriesNumMap() {
        this.regionTimeSeriesNumMap = null;
    }

    public boolean isSetRegionTimeSeriesNumMap() {
        return this.regionTimeSeriesNumMap != null;
    }

    public void setRegionTimeSeriesNumMapIsSet(boolean value) {
        if (!value) {
            this.regionTimeSeriesNumMap = null;
        }
    }

    public int getRegionDiskSize() {
        return this.regionDisk == null ? 0 : this.regionDisk.size();
    }

    public void putToRegionDisk(int key, long val) {
        if (this.regionDisk == null) {
            this.regionDisk = new HashMap<Integer, Long>();
        }
        this.regionDisk.put(key, val);
    }

    @Nullable
    public Map<Integer, Long> getRegionDisk() {
        return this.regionDisk;
    }

    public THeartbeatResp setRegionDisk(@Nullable Map<Integer, Long> regionDisk) {
        this.regionDisk = regionDisk;
        return this;
    }

    public void unsetRegionDisk() {
        this.regionDisk = null;
    }

    public boolean isSetRegionDisk() {
        return this.regionDisk != null;
    }

    public void setRegionDiskIsSet(boolean value) {
        if (!value) {
            this.regionDisk = null;
        }
    }

    @Nullable
    public TSchemaLimitLevel getSchemaLimitLevel() {
        return this.schemaLimitLevel;
    }

    public THeartbeatResp setSchemaLimitLevel(@Nullable TSchemaLimitLevel schemaLimitLevel) {
        this.schemaLimitLevel = schemaLimitLevel;
        return this;
    }

    public void unsetSchemaLimitLevel() {
        this.schemaLimitLevel = null;
    }

    public boolean isSetSchemaLimitLevel() {
        return this.schemaLimitLevel != null;
    }

    public void setSchemaLimitLevelIsSet(boolean value) {
        if (!value) {
            this.schemaLimitLevel = null;
        }
    }

    public int getPipeMetaListSize() {
        return this.pipeMetaList == null ? 0 : this.pipeMetaList.size();
    }

    @Nullable
    public Iterator<ByteBuffer> getPipeMetaListIterator() {
        return this.pipeMetaList == null ? null : this.pipeMetaList.iterator();
    }

    public void addToPipeMetaList(ByteBuffer elem) {
        if (this.pipeMetaList == null) {
            this.pipeMetaList = new ArrayList<ByteBuffer>();
        }
        this.pipeMetaList.add(elem);
    }

    @Nullable
    public List<ByteBuffer> getPipeMetaList() {
        return this.pipeMetaList;
    }

    public THeartbeatResp setPipeMetaList(@Nullable List<ByteBuffer> pipeMetaList) {
        this.pipeMetaList = pipeMetaList;
        return this;
    }

    public void unsetPipeMetaList() {
        this.pipeMetaList = null;
    }

    public boolean isSetPipeMetaList() {
        return this.pipeMetaList != null;
    }

    public void setPipeMetaListIsSet(boolean value) {
        if (!value) {
            this.pipeMetaList = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case HEARTBEAT_TIMESTAMP: {
                if (value == null) {
                    this.unsetHeartbeatTimestamp();
                    break;
                }
                this.setHeartbeatTimestamp((Long)value);
                break;
            }
            case STATUS: {
                if (value == null) {
                    this.unsetStatus();
                    break;
                }
                this.setStatus((String)value);
                break;
            }
            case STATUS_REASON: {
                if (value == null) {
                    this.unsetStatusReason();
                    break;
                }
                this.setStatusReason((String)value);
                break;
            }
            case JUDGED_LEADERS: {
                if (value == null) {
                    this.unsetJudgedLeaders();
                    break;
                }
                this.setJudgedLeaders((Map)value);
                break;
            }
            case LOAD_SAMPLE: {
                if (value == null) {
                    this.unsetLoadSample();
                    break;
                }
                this.setLoadSample((TLoadSample)value);
                break;
            }
            case REGION_DEVICE_NUM_MAP: {
                if (value == null) {
                    this.unsetRegionDeviceNumMap();
                    break;
                }
                this.setRegionDeviceNumMap((Map)value);
                break;
            }
            case REGION_TIME_SERIES_NUM_MAP: {
                if (value == null) {
                    this.unsetRegionTimeSeriesNumMap();
                    break;
                }
                this.setRegionTimeSeriesNumMap((Map)value);
                break;
            }
            case REGION_DISK: {
                if (value == null) {
                    this.unsetRegionDisk();
                    break;
                }
                this.setRegionDisk((Map)value);
                break;
            }
            case SCHEMA_LIMIT_LEVEL: {
                if (value == null) {
                    this.unsetSchemaLimitLevel();
                    break;
                }
                this.setSchemaLimitLevel((TSchemaLimitLevel)value);
                break;
            }
            case PIPE_META_LIST: {
                if (value == null) {
                    this.unsetPipeMetaList();
                    break;
                }
                this.setPipeMetaList((List)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case HEARTBEAT_TIMESTAMP: {
                return this.getHeartbeatTimestamp();
            }
            case STATUS: {
                return this.getStatus();
            }
            case STATUS_REASON: {
                return this.getStatusReason();
            }
            case JUDGED_LEADERS: {
                return this.getJudgedLeaders();
            }
            case LOAD_SAMPLE: {
                return this.getLoadSample();
            }
            case REGION_DEVICE_NUM_MAP: {
                return this.getRegionDeviceNumMap();
            }
            case REGION_TIME_SERIES_NUM_MAP: {
                return this.getRegionTimeSeriesNumMap();
            }
            case REGION_DISK: {
                return this.getRegionDisk();
            }
            case SCHEMA_LIMIT_LEVEL: {
                return this.getSchemaLimitLevel();
            }
            case PIPE_META_LIST: {
                return this.getPipeMetaList();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case HEARTBEAT_TIMESTAMP: {
                return this.isSetHeartbeatTimestamp();
            }
            case STATUS: {
                return this.isSetStatus();
            }
            case STATUS_REASON: {
                return this.isSetStatusReason();
            }
            case JUDGED_LEADERS: {
                return this.isSetJudgedLeaders();
            }
            case LOAD_SAMPLE: {
                return this.isSetLoadSample();
            }
            case REGION_DEVICE_NUM_MAP: {
                return this.isSetRegionDeviceNumMap();
            }
            case REGION_TIME_SERIES_NUM_MAP: {
                return this.isSetRegionTimeSeriesNumMap();
            }
            case REGION_DISK: {
                return this.isSetRegionDisk();
            }
            case SCHEMA_LIMIT_LEVEL: {
                return this.isSetSchemaLimitLevel();
            }
            case PIPE_META_LIST: {
                return this.isSetPipeMetaList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof THeartbeatResp) {
            return this.equals((THeartbeatResp)that);
        }
        return false;
    }

    public boolean equals(THeartbeatResp that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_heartbeatTimestamp = true;
        boolean that_present_heartbeatTimestamp = true;
        if (this_present_heartbeatTimestamp || that_present_heartbeatTimestamp) {
            if (!this_present_heartbeatTimestamp || !that_present_heartbeatTimestamp) {
                return false;
            }
            if (this.heartbeatTimestamp != that.heartbeatTimestamp) {
                return false;
            }
        }
        boolean this_present_status = this.isSetStatus();
        boolean that_present_status = that.isSetStatus();
        if (this_present_status || that_present_status) {
            if (!this_present_status || !that_present_status) {
                return false;
            }
            if (!this.status.equals(that.status)) {
                return false;
            }
        }
        boolean this_present_statusReason = this.isSetStatusReason();
        boolean that_present_statusReason = that.isSetStatusReason();
        if (this_present_statusReason || that_present_statusReason) {
            if (!this_present_statusReason || !that_present_statusReason) {
                return false;
            }
            if (!this.statusReason.equals(that.statusReason)) {
                return false;
            }
        }
        boolean this_present_judgedLeaders = this.isSetJudgedLeaders();
        boolean that_present_judgedLeaders = that.isSetJudgedLeaders();
        if (this_present_judgedLeaders || that_present_judgedLeaders) {
            if (!this_present_judgedLeaders || !that_present_judgedLeaders) {
                return false;
            }
            if (!this.judgedLeaders.equals(that.judgedLeaders)) {
                return false;
            }
        }
        boolean this_present_loadSample = this.isSetLoadSample();
        boolean that_present_loadSample = that.isSetLoadSample();
        if (this_present_loadSample || that_present_loadSample) {
            if (!this_present_loadSample || !that_present_loadSample) {
                return false;
            }
            if (!this.loadSample.equals(that.loadSample)) {
                return false;
            }
        }
        boolean this_present_regionDeviceNumMap = this.isSetRegionDeviceNumMap();
        boolean that_present_regionDeviceNumMap = that.isSetRegionDeviceNumMap();
        if (this_present_regionDeviceNumMap || that_present_regionDeviceNumMap) {
            if (!this_present_regionDeviceNumMap || !that_present_regionDeviceNumMap) {
                return false;
            }
            if (!this.regionDeviceNumMap.equals(that.regionDeviceNumMap)) {
                return false;
            }
        }
        boolean this_present_regionTimeSeriesNumMap = this.isSetRegionTimeSeriesNumMap();
        boolean that_present_regionTimeSeriesNumMap = that.isSetRegionTimeSeriesNumMap();
        if (this_present_regionTimeSeriesNumMap || that_present_regionTimeSeriesNumMap) {
            if (!this_present_regionTimeSeriesNumMap || !that_present_regionTimeSeriesNumMap) {
                return false;
            }
            if (!this.regionTimeSeriesNumMap.equals(that.regionTimeSeriesNumMap)) {
                return false;
            }
        }
        boolean this_present_regionDisk = this.isSetRegionDisk();
        boolean that_present_regionDisk = that.isSetRegionDisk();
        if (this_present_regionDisk || that_present_regionDisk) {
            if (!this_present_regionDisk || !that_present_regionDisk) {
                return false;
            }
            if (!this.regionDisk.equals(that.regionDisk)) {
                return false;
            }
        }
        boolean this_present_schemaLimitLevel = this.isSetSchemaLimitLevel();
        boolean that_present_schemaLimitLevel = that.isSetSchemaLimitLevel();
        if (this_present_schemaLimitLevel || that_present_schemaLimitLevel) {
            if (!this_present_schemaLimitLevel || !that_present_schemaLimitLevel) {
                return false;
            }
            if (!this.schemaLimitLevel.equals(that.schemaLimitLevel)) {
                return false;
            }
        }
        boolean this_present_pipeMetaList = this.isSetPipeMetaList();
        boolean that_present_pipeMetaList = that.isSetPipeMetaList();
        if (this_present_pipeMetaList || that_present_pipeMetaList) {
            if (!this_present_pipeMetaList || !that_present_pipeMetaList) {
                return false;
            }
            if (!this.pipeMetaList.equals(that.pipeMetaList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.heartbeatTimestamp);
        hashCode = hashCode * 8191 + (this.isSetStatus() ? 131071 : 524287);
        if (this.isSetStatus()) {
            hashCode = hashCode * 8191 + this.status.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStatusReason() ? 131071 : 524287);
        if (this.isSetStatusReason()) {
            hashCode = hashCode * 8191 + this.statusReason.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetJudgedLeaders() ? 131071 : 524287);
        if (this.isSetJudgedLeaders()) {
            hashCode = hashCode * 8191 + this.judgedLeaders.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLoadSample() ? 131071 : 524287);
        if (this.isSetLoadSample()) {
            hashCode = hashCode * 8191 + this.loadSample.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetRegionDeviceNumMap() ? 131071 : 524287);
        if (this.isSetRegionDeviceNumMap()) {
            hashCode = hashCode * 8191 + this.regionDeviceNumMap.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetRegionTimeSeriesNumMap() ? 131071 : 524287);
        if (this.isSetRegionTimeSeriesNumMap()) {
            hashCode = hashCode * 8191 + this.regionTimeSeriesNumMap.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetRegionDisk() ? 131071 : 524287);
        if (this.isSetRegionDisk()) {
            hashCode = hashCode * 8191 + this.regionDisk.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSchemaLimitLevel() ? 131071 : 524287);
        if (this.isSetSchemaLimitLevel()) {
            hashCode = hashCode * 8191 + this.schemaLimitLevel.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetPipeMetaList() ? 131071 : 524287);
        if (this.isSetPipeMetaList()) {
            hashCode = hashCode * 8191 + this.pipeMetaList.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(THeartbeatResp other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetHeartbeatTimestamp(), other.isSetHeartbeatTimestamp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHeartbeatTimestamp() && (lastComparison = TBaseHelper.compareTo(this.heartbeatTimestamp, other.heartbeatTimestamp)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStatus(), other.isSetStatus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatus() && (lastComparison = TBaseHelper.compareTo(this.status, other.status)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStatusReason(), other.isSetStatusReason());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatusReason() && (lastComparison = TBaseHelper.compareTo(this.statusReason, other.statusReason)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetJudgedLeaders(), other.isSetJudgedLeaders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJudgedLeaders() && (lastComparison = TBaseHelper.compareTo(this.judgedLeaders, other.judgedLeaders)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLoadSample(), other.isSetLoadSample());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLoadSample() && (lastComparison = TBaseHelper.compareTo(this.loadSample, other.loadSample)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRegionDeviceNumMap(), other.isSetRegionDeviceNumMap());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRegionDeviceNumMap() && (lastComparison = TBaseHelper.compareTo(this.regionDeviceNumMap, other.regionDeviceNumMap)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRegionTimeSeriesNumMap(), other.isSetRegionTimeSeriesNumMap());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRegionTimeSeriesNumMap() && (lastComparison = TBaseHelper.compareTo(this.regionTimeSeriesNumMap, other.regionTimeSeriesNumMap)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRegionDisk(), other.isSetRegionDisk());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRegionDisk() && (lastComparison = TBaseHelper.compareTo(this.regionDisk, other.regionDisk)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSchemaLimitLevel(), other.isSetSchemaLimitLevel());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaLimitLevel() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.schemaLimitLevel), (Comparable)((Object)other.schemaLimitLevel))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPipeMetaList(), other.isSetPipeMetaList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPipeMetaList() && (lastComparison = TBaseHelper.compareTo(this.pipeMetaList, other.pipeMetaList)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        THeartbeatResp.scheme(iprot).read(iprot, (THeartbeatResp)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        THeartbeatResp.scheme(oprot).write(oprot, (THeartbeatResp)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("THeartbeatResp(");
        boolean first = true;
        sb.append("heartbeatTimestamp:");
        sb.append(this.heartbeatTimestamp);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("status:");
        if (this.status == null) {
            sb.append("null");
        } else {
            sb.append(this.status);
        }
        first = false;
        if (this.isSetStatusReason()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("statusReason:");
            if (this.statusReason == null) {
                sb.append("null");
            } else {
                sb.append(this.statusReason);
            }
            first = false;
        }
        if (this.isSetJudgedLeaders()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("judgedLeaders:");
            if (this.judgedLeaders == null) {
                sb.append("null");
            } else {
                sb.append(this.judgedLeaders);
            }
            first = false;
        }
        if (this.isSetLoadSample()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("loadSample:");
            if (this.loadSample == null) {
                sb.append("null");
            } else {
                sb.append(this.loadSample);
            }
            first = false;
        }
        if (this.isSetRegionDeviceNumMap()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("regionDeviceNumMap:");
            if (this.regionDeviceNumMap == null) {
                sb.append("null");
            } else {
                sb.append(this.regionDeviceNumMap);
            }
            first = false;
        }
        if (this.isSetRegionTimeSeriesNumMap()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("regionTimeSeriesNumMap:");
            if (this.regionTimeSeriesNumMap == null) {
                sb.append("null");
            } else {
                sb.append(this.regionTimeSeriesNumMap);
            }
            first = false;
        }
        if (this.isSetRegionDisk()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("regionDisk:");
            if (this.regionDisk == null) {
                sb.append("null");
            } else {
                sb.append(this.regionDisk);
            }
            first = false;
        }
        if (this.isSetSchemaLimitLevel()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("schemaLimitLevel:");
            if (this.schemaLimitLevel == null) {
                sb.append("null");
            } else {
                sb.append(this.schemaLimitLevel);
            }
            first = false;
        }
        if (this.isSetPipeMetaList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("pipeMetaList:");
            if (this.pipeMetaList == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString(this.pipeMetaList, sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.status == null) {
            throw new TProtocolException("Required field 'status' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.HEARTBEAT_TIMESTAMP, new FieldMetaData("heartbeatTimestamp", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.STATUS, new FieldMetaData("status", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.STATUS_REASON, new FieldMetaData("statusReason", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.JUDGED_LEADERS, new FieldMetaData("judgedLeaders", 2, new MapMetaData(13, new StructMetaData(12, TConsensusGroupId.class), new FieldValueMetaData(2))));
        tmpMap.put(_Fields.LOAD_SAMPLE, new FieldMetaData("loadSample", 2, new FieldValueMetaData(12, "TLoadSample")));
        tmpMap.put(_Fields.REGION_DEVICE_NUM_MAP, new FieldMetaData("regionDeviceNumMap", 2, new MapMetaData(13, new FieldValueMetaData(8), new FieldValueMetaData(10))));
        tmpMap.put(_Fields.REGION_TIME_SERIES_NUM_MAP, new FieldMetaData("regionTimeSeriesNumMap", 2, new MapMetaData(13, new FieldValueMetaData(8), new FieldValueMetaData(10))));
        tmpMap.put(_Fields.REGION_DISK, new FieldMetaData("regionDisk", 2, new MapMetaData(13, new FieldValueMetaData(8), new FieldValueMetaData(10))));
        tmpMap.put(_Fields.SCHEMA_LIMIT_LEVEL, new FieldMetaData("schemaLimitLevel", 2, new FieldValueMetaData(16, "TSchemaLimitLevel")));
        tmpMap.put(_Fields.PIPE_META_LIST, new FieldMetaData("pipeMetaList", 2, new ListMetaData(15, new FieldValueMetaData(11, true))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(THeartbeatResp.class, metaDataMap);
    }

    private static class THeartbeatRespTupleScheme
    extends TupleScheme<THeartbeatResp> {
        private THeartbeatRespTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, THeartbeatResp struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.heartbeatTimestamp);
            oprot.writeString(struct.status);
            BitSet optionals = new BitSet();
            if (struct.isSetStatusReason()) {
                optionals.set(0);
            }
            if (struct.isSetJudgedLeaders()) {
                optionals.set(1);
            }
            if (struct.isSetLoadSample()) {
                optionals.set(2);
            }
            if (struct.isSetRegionDeviceNumMap()) {
                optionals.set(3);
            }
            if (struct.isSetRegionTimeSeriesNumMap()) {
                optionals.set(4);
            }
            if (struct.isSetRegionDisk()) {
                optionals.set(5);
            }
            if (struct.isSetSchemaLimitLevel()) {
                optionals.set(6);
            }
            if (struct.isSetPipeMetaList()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetStatusReason()) {
                oprot.writeString(struct.statusReason);
            }
            if (struct.isSetJudgedLeaders()) {
                oprot.writeI32(struct.judgedLeaders.size());
                for (Map.Entry<TConsensusGroupId, Boolean> entry : struct.judgedLeaders.entrySet()) {
                    entry.getKey().write(oprot);
                    oprot.writeBool(entry.getValue());
                }
            }
            if (struct.isSetLoadSample()) {
                struct.loadSample.write(oprot);
            }
            if (struct.isSetRegionDeviceNumMap()) {
                oprot.writeI32(struct.regionDeviceNumMap.size());
                for (Map.Entry<Comparable<TConsensusGroupId>, Comparable<Boolean>> entry : struct.regionDeviceNumMap.entrySet()) {
                    oprot.writeI32((Integer)entry.getKey());
                    oprot.writeI64((Long)entry.getValue());
                }
            }
            if (struct.isSetRegionTimeSeriesNumMap()) {
                oprot.writeI32(struct.regionTimeSeriesNumMap.size());
                for (Map.Entry<Comparable<TConsensusGroupId>, Comparable<Boolean>> entry : struct.regionTimeSeriesNumMap.entrySet()) {
                    oprot.writeI32((Integer)entry.getKey());
                    oprot.writeI64((Long)entry.getValue());
                }
            }
            if (struct.isSetRegionDisk()) {
                oprot.writeI32(struct.regionDisk.size());
                for (Map.Entry<Comparable<TConsensusGroupId>, Comparable<Boolean>> entry : struct.regionDisk.entrySet()) {
                    oprot.writeI32((Integer)entry.getKey());
                    oprot.writeI64((Long)entry.getValue());
                }
            }
            if (struct.isSetSchemaLimitLevel()) {
                oprot.writeI32(struct.schemaLimitLevel.getValue());
            }
            if (struct.isSetPipeMetaList()) {
                oprot.writeI32(struct.pipeMetaList.size());
                for (ByteBuffer byteBuffer : struct.pipeMetaList) {
                    oprot.writeBinary(byteBuffer);
                }
            }
        }

        @Override
        public void read(TProtocol prot, THeartbeatResp struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.heartbeatTimestamp = iprot.readI64();
            struct.setHeartbeatTimestampIsSet(true);
            struct.status = iprot.readString();
            struct.setStatusIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.statusReason = iprot.readString();
                struct.setStatusReasonIsSet(true);
            }
            if (incoming.get(1)) {
                TMap _map119 = iprot.readMapBegin((byte)12, (byte)2);
                struct.judgedLeaders = new HashMap<TConsensusGroupId, Boolean>(2 * _map119.size);
                for (int _i122 = 0; _i122 < _map119.size; ++_i122) {
                    TConsensusGroupId _key120 = new TConsensusGroupId();
                    _key120.read(iprot);
                    boolean _val121 = iprot.readBool();
                    struct.judgedLeaders.put(_key120, _val121);
                }
                struct.setJudgedLeadersIsSet(true);
            }
            if (incoming.get(2)) {
                struct.loadSample = new TLoadSample();
                struct.loadSample.read(iprot);
                struct.setLoadSampleIsSet(true);
            }
            if (incoming.get(3)) {
                TMap _map123 = iprot.readMapBegin((byte)8, (byte)10);
                struct.regionDeviceNumMap = new HashMap<Integer, Long>(2 * _map123.size);
                for (int _i126 = 0; _i126 < _map123.size; ++_i126) {
                    int _key124 = iprot.readI32();
                    long _val125 = iprot.readI64();
                    struct.regionDeviceNumMap.put(_key124, _val125);
                }
                struct.setRegionDeviceNumMapIsSet(true);
            }
            if (incoming.get(4)) {
                TMap _map127 = iprot.readMapBegin((byte)8, (byte)10);
                struct.regionTimeSeriesNumMap = new HashMap<Integer, Long>(2 * _map127.size);
                for (int _i130 = 0; _i130 < _map127.size; ++_i130) {
                    int _key128 = iprot.readI32();
                    long _val129 = iprot.readI64();
                    struct.regionTimeSeriesNumMap.put(_key128, _val129);
                }
                struct.setRegionTimeSeriesNumMapIsSet(true);
            }
            if (incoming.get(5)) {
                TMap _map131 = iprot.readMapBegin((byte)8, (byte)10);
                struct.regionDisk = new HashMap<Integer, Long>(2 * _map131.size);
                for (int _i134 = 0; _i134 < _map131.size; ++_i134) {
                    int _key132 = iprot.readI32();
                    long _val133 = iprot.readI64();
                    struct.regionDisk.put(_key132, _val133);
                }
                struct.setRegionDiskIsSet(true);
            }
            if (incoming.get(6)) {
                struct.schemaLimitLevel = TSchemaLimitLevel.findByValue(iprot.readI32());
                struct.setSchemaLimitLevelIsSet(true);
            }
            if (incoming.get(7)) {
                TList _list135 = iprot.readListBegin((byte)11);
                struct.pipeMetaList = new ArrayList<ByteBuffer>(_list135.size);
                for (int _i137 = 0; _i137 < _list135.size; ++_i137) {
                    ByteBuffer _elem136 = iprot.readBinary();
                    struct.pipeMetaList.add(_elem136);
                }
                struct.setPipeMetaListIsSet(true);
            }
        }
    }

    private static class THeartbeatRespTupleSchemeFactory
    implements SchemeFactory {
        private THeartbeatRespTupleSchemeFactory() {
        }

        public THeartbeatRespTupleScheme getScheme() {
            return new THeartbeatRespTupleScheme();
        }
    }

    private static class THeartbeatRespStandardScheme
    extends StandardScheme<THeartbeatResp> {
        private THeartbeatRespStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, THeartbeatResp struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.heartbeatTimestamp = iprot.readI64();
                            struct.setHeartbeatTimestampIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.status = iprot.readString();
                            struct.setStatusIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.statusReason = iprot.readString();
                            struct.setStatusReasonIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map90 = iprot.readMapBegin();
                            struct.judgedLeaders = new HashMap<TConsensusGroupId, Boolean>(2 * _map90.size);
                            for (int _i93 = 0; _i93 < _map90.size; ++_i93) {
                                TConsensusGroupId _key91 = new TConsensusGroupId();
                                _key91.read(iprot);
                                boolean _val92 = iprot.readBool();
                                struct.judgedLeaders.put(_key91, _val92);
                            }
                            iprot.readMapEnd();
                            struct.setJudgedLeadersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.loadSample = new TLoadSample();
                            struct.loadSample.read(iprot);
                            struct.setLoadSampleIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 13) {
                            TMap _map94 = iprot.readMapBegin();
                            struct.regionDeviceNumMap = new HashMap<Integer, Long>(2 * _map94.size);
                            for (int _i97 = 0; _i97 < _map94.size; ++_i97) {
                                int _key95 = iprot.readI32();
                                long _val96 = iprot.readI64();
                                struct.regionDeviceNumMap.put(_key95, _val96);
                            }
                            iprot.readMapEnd();
                            struct.setRegionDeviceNumMapIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 13) {
                            TMap _map98 = iprot.readMapBegin();
                            struct.regionTimeSeriesNumMap = new HashMap<Integer, Long>(2 * _map98.size);
                            for (int _i101 = 0; _i101 < _map98.size; ++_i101) {
                                int _key99 = iprot.readI32();
                                long _val100 = iprot.readI64();
                                struct.regionTimeSeriesNumMap.put(_key99, _val100);
                            }
                            iprot.readMapEnd();
                            struct.setRegionTimeSeriesNumMapIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 13) {
                            TMap _map102 = iprot.readMapBegin();
                            struct.regionDisk = new HashMap<Integer, Long>(2 * _map102.size);
                            for (int _i105 = 0; _i105 < _map102.size; ++_i105) {
                                int _key103 = iprot.readI32();
                                long _val104 = iprot.readI64();
                                struct.regionDisk.put(_key103, _val104);
                            }
                            iprot.readMapEnd();
                            struct.setRegionDiskIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.schemaLimitLevel = TSchemaLimitLevel.findByValue(iprot.readI32());
                            struct.setSchemaLimitLevelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list106 = iprot.readListBegin();
                            struct.pipeMetaList = new ArrayList<ByteBuffer>(_list106.size);
                            for (int _i108 = 0; _i108 < _list106.size; ++_i108) {
                                ByteBuffer _elem107 = iprot.readBinary();
                                struct.pipeMetaList.add(_elem107);
                            }
                            iprot.readListEnd();
                            struct.setPipeMetaListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetHeartbeatTimestamp()) {
                throw new TProtocolException("Required field 'heartbeatTimestamp' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, THeartbeatResp struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(HEARTBEAT_TIMESTAMP_FIELD_DESC);
            oprot.writeI64(struct.heartbeatTimestamp);
            oprot.writeFieldEnd();
            if (struct.status != null) {
                oprot.writeFieldBegin(STATUS_FIELD_DESC);
                oprot.writeString(struct.status);
                oprot.writeFieldEnd();
            }
            if (struct.statusReason != null && struct.isSetStatusReason()) {
                oprot.writeFieldBegin(STATUS_REASON_FIELD_DESC);
                oprot.writeString(struct.statusReason);
                oprot.writeFieldEnd();
            }
            if (struct.judgedLeaders != null && struct.isSetJudgedLeaders()) {
                oprot.writeFieldBegin(JUDGED_LEADERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(12, 2, struct.judgedLeaders.size()));
                for (Map.Entry<TConsensusGroupId, Boolean> entry : struct.judgedLeaders.entrySet()) {
                    entry.getKey().write(oprot);
                    oprot.writeBool(entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.loadSample != null && struct.isSetLoadSample()) {
                oprot.writeFieldBegin(LOAD_SAMPLE_FIELD_DESC);
                struct.loadSample.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.regionDeviceNumMap != null && struct.isSetRegionDeviceNumMap()) {
                oprot.writeFieldBegin(REGION_DEVICE_NUM_MAP_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 10, struct.regionDeviceNumMap.size()));
                for (Map.Entry<Comparable<TConsensusGroupId>, Comparable<Boolean>> entry : struct.regionDeviceNumMap.entrySet()) {
                    oprot.writeI32((Integer)entry.getKey());
                    oprot.writeI64((Long)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.regionTimeSeriesNumMap != null && struct.isSetRegionTimeSeriesNumMap()) {
                oprot.writeFieldBegin(REGION_TIME_SERIES_NUM_MAP_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 10, struct.regionTimeSeriesNumMap.size()));
                for (Map.Entry<Comparable<TConsensusGroupId>, Comparable<Boolean>> entry : struct.regionTimeSeriesNumMap.entrySet()) {
                    oprot.writeI32((Integer)entry.getKey());
                    oprot.writeI64((Long)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.regionDisk != null && struct.isSetRegionDisk()) {
                oprot.writeFieldBegin(REGION_DISK_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 10, struct.regionDisk.size()));
                for (Map.Entry<Comparable<TConsensusGroupId>, Comparable<Boolean>> entry : struct.regionDisk.entrySet()) {
                    oprot.writeI32((Integer)entry.getKey());
                    oprot.writeI64((Long)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.schemaLimitLevel != null && struct.isSetSchemaLimitLevel()) {
                oprot.writeFieldBegin(SCHEMA_LIMIT_LEVEL_FIELD_DESC);
                oprot.writeI32(struct.schemaLimitLevel.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.pipeMetaList != null && struct.isSetPipeMetaList()) {
                oprot.writeFieldBegin(PIPE_META_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.pipeMetaList.size()));
                for (ByteBuffer byteBuffer : struct.pipeMetaList) {
                    oprot.writeBinary(byteBuffer);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class THeartbeatRespStandardSchemeFactory
    implements SchemeFactory {
        private THeartbeatRespStandardSchemeFactory() {
        }

        public THeartbeatRespStandardScheme getScheme() {
            return new THeartbeatRespStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        HEARTBEAT_TIMESTAMP(1, "heartbeatTimestamp"),
        STATUS(2, "status"),
        STATUS_REASON(3, "statusReason"),
        JUDGED_LEADERS(4, "judgedLeaders"),
        LOAD_SAMPLE(5, "loadSample"),
        REGION_DEVICE_NUM_MAP(6, "regionDeviceNumMap"),
        REGION_TIME_SERIES_NUM_MAP(7, "regionTimeSeriesNumMap"),
        REGION_DISK(8, "regionDisk"),
        SCHEMA_LIMIT_LEVEL(9, "schemaLimitLevel"),
        PIPE_META_LIST(10, "pipeMetaList");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return HEARTBEAT_TIMESTAMP;
                }
                case 2: {
                    return STATUS;
                }
                case 3: {
                    return STATUS_REASON;
                }
                case 4: {
                    return JUDGED_LEADERS;
                }
                case 5: {
                    return LOAD_SAMPLE;
                }
                case 6: {
                    return REGION_DEVICE_NUM_MAP;
                }
                case 7: {
                    return REGION_TIME_SERIES_NUM_MAP;
                }
                case 8: {
                    return REGION_DISK;
                }
                case 9: {
                    return SCHEMA_LIMIT_LEVEL;
                }
                case 10: {
                    return PIPE_META_LIST;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

