/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.type;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.metrics.type.Gauge;

public class MicrometerGauge
implements Gauge {
    private final AtomicLong atomicLong;

    public MicrometerGauge(MeterRegistry meterRegistry, String metricName, String ... tags) {
        this.atomicLong = meterRegistry.gauge(metricName, Tags.of(tags), new AtomicLong(0L));
    }

    @Override
    public long value() {
        return this.atomicLong.get();
    }

    @Override
    public void incr(long value) {
        this.atomicLong.addAndGet(value);
    }

    @Override
    public void decr(long value) {
        this.atomicLong.addAndGet(-value);
    }

    @Override
    public void set(long value) {
        this.atomicLong.set(value);
    }
}

