/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.type;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.lang.ref.WeakReference;
import java.util.function.ToDoubleFunction;
import org.apache.iotdb.metrics.type.AutoGauge;

public class MicrometerAutoGauge<T>
implements AutoGauge {
    private final WeakReference<T> refObject;
    private final ToDoubleFunction<T> mapper;

    public MicrometerAutoGauge(MeterRegistry meterRegistry, String metricName, T object, ToDoubleFunction<T> mapper, String ... tags) {
        this.refObject = new WeakReference<T>(meterRegistry.gauge(metricName, Tags.of(tags), object, mapper));
        this.mapper = mapper;
    }

    @Override
    public double value() {
        if (this.refObject.get() == null) {
            return 0.0;
        }
        return this.mapper.applyAsDouble(this.refObject.get());
    }
}

