/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToDoubleFunction;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.micrometer.type.MicrometerAutoGauge;
import org.apache.iotdb.metrics.micrometer.type.MicrometerCounter;
import org.apache.iotdb.metrics.micrometer.type.MicrometerGauge;
import org.apache.iotdb.metrics.micrometer.type.MicrometerHistogram;
import org.apache.iotdb.metrics.micrometer.type.MicrometerRate;
import org.apache.iotdb.metrics.micrometer.type.MicrometerTimer;
import org.apache.iotdb.metrics.type.AutoGauge;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.type.Rate;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;

public class MicrometerMetricManager
extends AbstractMetricManager {
    MeterRegistry meterRegistry = Metrics.globalRegistry;

    public MicrometerMetricManager() {
        Metrics.globalRegistry.add(new SimpleMeterRegistry());
    }

    @Override
    public Counter createCounter(MetricInfo metricInfo) {
        return new MicrometerCounter(this.meterRegistry.counter(metricInfo.getName(), metricInfo.getTagsInArray()));
    }

    @Override
    public <T> AutoGauge createAutoGauge(MetricInfo metricInfo, T obj, ToDoubleFunction<T> mapper) {
        return new MicrometerAutoGauge<T>(this.meterRegistry, metricInfo.getName(), obj, mapper, metricInfo.getTagsInArray());
    }

    @Override
    public Gauge createGauge(MetricInfo metricInfo) {
        return new MicrometerGauge(this.meterRegistry, metricInfo.getName(), metricInfo.getTagsInArray());
    }

    @Override
    public Histogram createHistogram(MetricInfo metricInfo) {
        DistributionSummary distributionSummary = DistributionSummary.builder(metricInfo.getName()).tags(metricInfo.getTagsInArray()).publishPercentiles(0.5, 0.99).register(this.meterRegistry);
        return new MicrometerHistogram(distributionSummary);
    }

    @Override
    public Rate createRate(MetricInfo metricInfo) {
        return new MicrometerRate(this.meterRegistry.gauge(metricInfo.getName(), Tags.of(metricInfo.getTagsInArray()), new AtomicLong(0L)));
    }

    @Override
    public Timer createTimer(MetricInfo metricInfo) {
        io.micrometer.core.instrument.Timer timer = io.micrometer.core.instrument.Timer.builder(metricInfo.getName()).tags(metricInfo.getTagsInArray()).publishPercentiles(0.5, 0.99).register(this.meterRegistry);
        return new MicrometerTimer(timer);
    }

    @Override
    protected void removeMetric(MetricType type, MetricInfo metricInfo) {
        Meter.Type meterType = this.transformType(type);
        Meter.Id id = new Meter.Id(metricInfo.getName(), Tags.of(metricInfo.getTagsInArray()), null, null, meterType);
        this.meterRegistry.remove(id);
    }

    @Override
    public boolean stopFramework() {
        this.meterRegistry.clear();
        return true;
    }

    private Meter.Type transformType(MetricType type) {
        switch (type) {
            case COUNTER: {
                return Meter.Type.COUNTER;
            }
            case AUTO_GAUGE: 
            case GAUGE: 
            case RATE: {
                return Meter.Type.GAUGE;
            }
            case HISTOGRAM: {
                return Meter.Type.DISTRIBUTION_SUMMARY;
            }
            case TIMER: {
                return Meter.Type.TIMER;
            }
        }
        return Meter.Type.OTHER;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MicrometerMetricManager that = (MicrometerMetricManager)o;
        return Objects.equals(this.meterRegistry, that.meterRegistry);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.meterRegistry);
    }
}

