/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.logback.MetricsTurboFilter;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(LogbackMetrics.class);
    private static final String LEVEL = "level";
    static ThreadLocal<Boolean> ignoreMetrics = new ThreadLocal();
    private final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    private final Map<AbstractMetricService, MetricsTurboFilter> metricsTurboFilters = new HashMap<AbstractMetricService, MetricsTurboFilter>();

    public LogbackMetrics() {
        this.loggerContext.addListener(new LoggerContextListener(){

            @Override
            public boolean isResetResistant() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReset(LoggerContext context) {
                Map map = LogbackMetrics.this.metricsTurboFilters;
                synchronized (map) {
                    for (MetricsTurboFilter addMetricsTurboFilter : LogbackMetrics.this.metricsTurboFilters.values()) {
                        LogbackMetrics.this.loggerContext.addTurboFilter(addMetricsTurboFilter);
                    }
                }
            }

            @Override
            public void onStart(LoggerContext context) {
            }

            @Override
            public void onStop(LoggerContext context) {
            }

            @Override
            public void onLevelChange(ch.qos.logback.classic.Logger logger, Level level) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTo(AbstractMetricService metricService) {
        MetricsTurboFilter filter = new MetricsTurboFilter(metricService);
        Map<AbstractMetricService, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            this.metricsTurboFilters.put(metricService, filter);
            this.loggerContext.addTurboFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        try {
            Map<AbstractMetricService, MetricsTurboFilter> map = this.metricsTurboFilters;
            synchronized (map) {
                for (MetricsTurboFilter addMetricsTurboFilter : this.metricsTurboFilters.values()) {
                    this.loggerContext.getTurboFilterList().remove(addMetricsTurboFilter);
                }
                metricService.remove(MetricType.COUNTER, SystemMetric.LOGBACK_EVENTS.toString(), LEVEL, "error");
                metricService.remove(MetricType.COUNTER, SystemMetric.LOGBACK_EVENTS.toString(), LEVEL, "warn");
                metricService.remove(MetricType.COUNTER, SystemMetric.LOGBACK_EVENTS.toString(), LEVEL, "info");
                metricService.remove(MetricType.COUNTER, SystemMetric.LOGBACK_EVENTS.toString(), LEVEL, "debug");
                metricService.remove(MetricType.COUNTER, SystemMetric.LOGBACK_EVENTS.toString(), LEVEL, "trace");
            }
        }
        catch (Exception e) {
            logger.warn("Failed to remove logBackMetrics, because ", e);
        }
    }
}

